/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.exception.IncorrectDefinitionException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.partition.DataSourceRouter;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class DataSourceGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DataSourceGenerator.class);
    private final DataSourceFactory dataSourceFactory;
    private final DataSourceType dataSourceType;
    private final String dataSourceName;
    private final String shardParameterName;
    private final GetterInvokerGroup shardByInvokerGroup;
    private final DataSourceRouter dataSourceRouter;

    public DataSourceGenerator(DataSourceFactory dataSourceFactory, DataSourceType dataSourceType, String dataSourceName, String shardParameterName, GetterInvokerGroup shardByInvokerGroup, DataSourceRouter dataSourceRouter) {
        this.dataSourceFactory = dataSourceFactory;
        this.dataSourceType = dataSourceType;
        this.dataSourceName = dataSourceName;
        this.shardParameterName = shardParameterName;
        this.shardByInvokerGroup = shardByInvokerGroup;
        this.dataSourceRouter = dataSourceRouter;
    }

    public DataSource getDataSource(InvocationContext context) {
        return this.getDataSource(this.getDataSourceName(context));
    }

    public DataSource getDataSource(String dataSourceName) {
        DataSource ds;
        if (logger.isDebugEnabled()) {
            logger.debug("The name of Datasource is [" + dataSourceName + "]");
        }
        if ((ds = this.dataSourceFactory.getDataSource(dataSourceName, this.dataSourceType)) == null) {
            throw new IncorrectDefinitionException("can't find datasource for name [" + dataSourceName + "]");
        }
        return ds;
    }

    @Nullable
    public String getDataSourceName(InvocationContext context) {
        String realDataSourceName = this.dataSourceRouter != null ? this.dataSourceRouter.getDataSourceName(context.getPropertyValue(this.shardParameterName, this.shardByInvokerGroup)) : this.dataSourceName;
        return realDataSourceName;
    }
}

