/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.LinkedList;
import java.util.List;
import org.jfaster.mango.operator.Interceptor;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.reflect.Parameter;
import org.jfaster.mango.util.SQLType;

public class InterceptorChain {
    private List<Interceptor> interceptors;

    public void addInterceptor(Interceptor interceptor) {
        this.initInterceptorList();
        this.interceptors.add(interceptor);
    }

    public void intercept(PreparedSql preparedSql, List<Parameter> parameters, SQLType sqlType) {
        if (this.getInterceptors() != null) {
            for (Interceptor interceptor : this.getInterceptors()) {
                interceptor.intercept(preparedSql, parameters, sqlType);
            }
        }
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    private void initInterceptorList() {
        if (this.interceptors == null) {
            this.interceptors = new LinkedList<Interceptor>();
        }
    }
}

