/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.exception.NotReadableParameterException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.util.Strings;

public class InvocationContext {
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private final List<Object> parameterValues = new LinkedList<Object>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> args = new LinkedList<Object>();
    private String globalTable;

    public void addParameter(String parameterName, Object parameterValue) {
        this.parameterMap.put(parameterName, parameterValue);
        this.parameterValues.add(parameterValue);
    }

    public Object getPropertyValue(String parameterName, GetterInvokerGroup invokerGroup) {
        Object value = this.getNullablePropertyValue(parameterName, invokerGroup);
        if (value == null) {
            String fullName = Strings.getFullName(parameterName, invokerGroup.getPropertyPath());
            String key = Strings.isEmpty(invokerGroup.getPropertyPath()) ? "parameter" : "property";
            throw new NullPointerException(key + " " + fullName + " need a non-null value");
        }
        return value;
    }

    @Nullable
    public Object getNullablePropertyValue(String parameterName, GetterInvokerGroup invokerGroup) {
        String key = this.getCacheKey(parameterName, invokerGroup);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (!this.parameterMap.containsKey(parameterName)) {
            throw new NotReadableParameterException("parameter :" + parameterName + " is not readable");
        }
        Object obj = this.parameterMap.get(parameterName);
        Object value = invokerGroup.invoke(obj);
        this.cache.put(key, value);
        return value;
    }

    public void setPropertyValue(String parameterName, GetterInvokerGroup invokerGroup, Object propertyValue) {
        String key = this.getCacheKey(parameterName, invokerGroup);
        this.cache.put(key, propertyValue);
    }

    @Nullable
    public String getGlobalTable() {
        return this.globalTable;
    }

    public void setGlobalTable(String globalTable) {
        this.globalTable = globalTable;
    }

    public void writeToSqlBuffer(String str) {
        this.sql.append(str);
    }

    public void appendToArgs(Object obj) {
        this.args.add(obj);
    }

    public PreparedSql getPreparedSql() {
        return new PreparedSql(this.sql.toString(), this.args);
    }

    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    private String getCacheKey(String parameterName, GetterInvokerGroup invokerGroup) {
        return invokerGroup == null ? parameterName : parameterName + "." + invokerGroup.getPropertyPath();
    }
}

