/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.operator.InterceptorChain;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.reflect.Parameter;
import org.jfaster.mango.reflect.ParameterDescriptor;
import org.jfaster.mango.util.SQLType;

public class InvocationInterceptorChain {
    private InterceptorChain interceptorChain;
    private List<ParameterDescriptor> parameterDescriptors;
    private SQLType sqlType;

    public InvocationInterceptorChain(InterceptorChain interceptorChain, List<ParameterDescriptor> parameterDescriptors, SQLType sqlType) {
        this.interceptorChain = interceptorChain;
        this.parameterDescriptors = parameterDescriptors;
        this.sqlType = sqlType;
    }

    public void intercept(PreparedSql preparedSql, InvocationContext context) {
        if (this.interceptorChain.getInterceptors() != null) {
            List<Object> parameterValues = context.getParameterValues();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterValues.size());
            for (int i = 0; i < parameterValues.size(); ++i) {
                ParameterDescriptor pd = this.parameterDescriptors.get(i);
                parameters.add(new Parameter(pd, parameterValues.get(i)));
            }
            this.interceptorChain.intercept(preparedSql, parameters, this.sqlType);
        }
    }
}

