/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.datasource.SimpleDataSourceFactory;
import org.jfaster.mango.exception.InitializationException;
import org.jfaster.mango.jdbc.JdbcOperations;
import org.jfaster.mango.jdbc.JdbcTemplate;
import org.jfaster.mango.operator.Interceptor;
import org.jfaster.mango.operator.InterceptorChain;
import org.jfaster.mango.operator.Operator;
import org.jfaster.mango.operator.OperatorFactory;
import org.jfaster.mango.operator.OperatorStats;
import org.jfaster.mango.operator.StatsCounter;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.reflect.AbstractInvocationHandler;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.reflect.Methods;
import org.jfaster.mango.reflect.ParameterNameDiscover;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.reflect.SerialNumberParameterNameDiscover;
import org.jfaster.mango.util.ToStringHelper;
import org.jfaster.mango.util.concurrent.cache.CacheLoader;
import org.jfaster.mango.util.concurrent.cache.DoubleCheckCache;
import org.jfaster.mango.util.concurrent.cache.LoadingCache;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class Mango {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Mango.class);
    private DataSourceFactory dataSourceFactory;
    private CacheHandler defaultCacheHandler;
    private boolean defaultLazyInit = false;
    private InterceptorChain interceptorChain = new InterceptorChain();
    private JdbcOperations jdbcOperations = new JdbcTemplate();
    private ParameterNameDiscover parameterNameDiscover = new SerialNumberParameterNameDiscover();
    private final ConcurrentHashMap<Method, StatsCounter> statsCounterMap = new ConcurrentHashMap();
    private static final CopyOnWriteArrayList<Mango> instances = new CopyOnWriteArrayList();

    private Mango() {
    }

    public static synchronized Mango newInstance() {
        if (instances.size() == 1 && logger.isWarnEnabled()) {
            logger.warn("Find out more mango instances, it is recommended to use only one");
        }
        Mango mango = new Mango();
        instances.add(mango);
        return mango;
    }

    public static Mango newInstance(DataSource dataSource) {
        return Mango.newInstance().setDataSource(dataSource);
    }

    public static Mango newInstance(DataSourceFactory dataSourceFactory) {
        return Mango.newInstance().setDataSourceFactory(dataSourceFactory);
    }

    public static List<Mango> getInstances() {
        ArrayList<Mango> mangos = new ArrayList<Mango>();
        for (Mango instance : instances) {
            mangos.add(instance);
        }
        return Collections.unmodifiableList(mangos);
    }

    public Mango addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor can't be null");
        }
        if (this.interceptorChain == null) {
            this.interceptorChain = new InterceptorChain();
        }
        this.interceptorChain.addInterceptor(interceptor);
        return this;
    }

    public <T> T create(Class<T> daoClass) {
        return this.create(daoClass, this.defaultCacheHandler, this.defaultLazyInit);
    }

    public <T> T create(Class<T> daoClass, @Nullable CacheHandler cacheHandler) {
        return this.create(daoClass, cacheHandler, this.defaultLazyInit);
    }

    public <T> T create(Class<T> daoClass, boolean lazyInit) {
        return this.create(daoClass, this.defaultCacheHandler, lazyInit);
    }

    public <T> T create(Class<T> daoClass, @Nullable CacheHandler cacheHandler, boolean lazyInit) {
        Cache cacheAnno;
        if (daoClass == null) {
            throw new NullPointerException("dao interface can't be null");
        }
        if (!daoClass.isInterface()) {
            throw new IllegalArgumentException("expected an interface to proxy, but " + daoClass);
        }
        DB dbAnno = daoClass.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new IllegalStateException("dao interface expected one @DB annotation but not found");
        }
        if (cacheHandler == null) {
            cacheHandler = this.defaultCacheHandler;
        }
        if ((cacheAnno = daoClass.getAnnotation(Cache.class)) != null && cacheHandler == null) {
            throw new IllegalStateException("if @Cache annotation on dao interface, cacheHandler can't be null");
        }
        if (this.dataSourceFactory == null) {
            throw new IllegalArgumentException("dataSourceFactory can't be null");
        }
        MangoInvocationHandler handler = new MangoInvocationHandler(this, cacheHandler);
        if (!lazyInit) {
            Method[] methods;
            for (Method method : methods = daoClass.getMethods()) {
                try {
                    handler.getOperator(method);
                }
                catch (Throwable e) {
                    throw new InitializationException("initialize " + ToStringHelper.toString(method) + " error", e);
                }
            }
        }
        return Reflection.newProxy(daoClass, handler);
    }

    public List<OperatorStats> getAllStats() {
        ArrayList<OperatorStats> oss = new ArrayList<OperatorStats>();
        Set<Map.Entry<Method, StatsCounter>> entrySet = this.statsCounterMap.entrySet();
        for (Map.Entry<Method, StatsCounter> entry : entrySet) {
            Method method = entry.getKey();
            OperatorStats os = entry.getValue().snapshot();
            os.setMethod(method);
            oss.add(os);
        }
        Collections.sort(oss, new Comparator<OperatorStats>(){

            @Override
            public int compare(OperatorStats o1, OperatorStats o2) {
                long c2;
                long c1 = o1.getExecuteCount();
                return c1 < (c2 = o2.getExecuteCount()) ? 1 : (c1 > c2 ? -1 : 0);
            }
        });
        return oss;
    }

    public void resetAllStats() {
        Set<Map.Entry<Method, StatsCounter>> entrySet = this.statsCounterMap.entrySet();
        for (Map.Entry<Method, StatsCounter> entry : entrySet) {
            entry.getValue().reset();
        }
    }

    public DataSource getMasterDataSource(String dataSourceName) {
        return this.dataSourceFactory.getDataSource(dataSourceName, DataSourceType.MASTER);
    }

    public Mango setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource can't be null");
        }
        this.dataSourceFactory = new SimpleDataSourceFactory(dataSource);
        return this;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public Mango setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory can't be null");
        }
        this.dataSourceFactory = dataSourceFactory;
        return this;
    }

    public CacheHandler getDefaultCacheHandler() {
        return this.defaultCacheHandler;
    }

    public Mango setDefaultCacheHandler(CacheHandler defaultCacheHandler) {
        if (defaultCacheHandler == null) {
            throw new NullPointerException("defaultCacheHandler can't be null");
        }
        this.defaultCacheHandler = defaultCacheHandler;
        return this;
    }

    public boolean isDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    public Mango setDefaultLazyInit(boolean defaultLazyInit) {
        this.defaultLazyInit = defaultLazyInit;
        return this;
    }

    public Mango setInterceptorChain(InterceptorChain interceptorChain) {
        if (interceptorChain == null) {
            throw new NullPointerException("interceptorChain can't be null");
        }
        this.interceptorChain = interceptorChain;
        return this;
    }

    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    public Mango setJdbcOperations(JdbcOperations jdbcOperations) {
        if (jdbcOperations == null) {
            throw new NullPointerException("jdbcOperations can't be null");
        }
        this.jdbcOperations = jdbcOperations;
        return this;
    }

    public ParameterNameDiscover getParameterNameDiscover() {
        return this.parameterNameDiscover;
    }

    public Mango setParameterNameDiscover(ParameterNameDiscover parameterNameDiscover) {
        if (parameterNameDiscover == null) {
            throw new NullPointerException("parameterNameDiscover can't be null");
        }
        this.parameterNameDiscover = parameterNameDiscover;
        return this;
    }

    private static class MangoInvocationHandler
    extends AbstractInvocationHandler
    implements InvocationHandler {
        private final JdbcOperations jdbcOperations;
        private final ConcurrentHashMap<Method, StatsCounter> statsCounterMap;
        private final OperatorFactory operatorFactory;
        private final ParameterNameDiscover parameterNameDiscover;
        private final LoadingCache<Method, Operator> cache = new DoubleCheckCache<Method, Operator>(new CacheLoader<Method, Operator>(){

            @Override
            public Operator load(Method method) {
                if (logger.isInfoEnabled()) {
                    logger.info("initializing operator for {}", (Object)ToStringHelper.toString(method));
                }
                StatsCounter statsCounter = MangoInvocationHandler.this.getStatusCounter(method);
                long now = System.nanoTime();
                MethodDescriptor md = Methods.getMethodDescriptor(method, MangoInvocationHandler.this.parameterNameDiscover);
                Operator operator = MangoInvocationHandler.this.operatorFactory.getOperator(md);
                operator.setJdbcOperations(MangoInvocationHandler.this.jdbcOperations);
                operator.setStatsCounter(statsCounter);
                statsCounter.recordInit(System.nanoTime() - now);
                return operator;
            }
        });

        private MangoInvocationHandler(Mango mango, @Nullable CacheHandler cacheHandler) {
            this.jdbcOperations = mango.jdbcOperations;
            this.statsCounterMap = mango.statsCounterMap;
            this.operatorFactory = new OperatorFactory(mango.dataSourceFactory, cacheHandler, mango.interceptorChain);
            this.parameterNameDiscover = mango.parameterNameDiscover;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (logger.isDebugEnabled()) {
                logger.debug("{} #args={}", (Object)ToStringHelper.toString(method), (Object)args);
            }
            Operator operator = this.getOperator(method);
            Object r = operator.execute(args);
            if (logger.isDebugEnabled()) {
                logger.debug("{} #result={}", (Object)ToStringHelper.toString(method), r);
            }
            return r;
        }

        Operator getOperator(Method method) {
            return this.cache.get(method);
        }

        private StatsCounter getStatusCounter(Method method) {
            StatsCounter old;
            StatsCounter statsCounter = this.statsCounterMap.get(method);
            if (statsCounter == null && (old = this.statsCounterMap.putIfAbsent(method, statsCounter = new StatsCounter())) != null) {
                statsCounter = old;
            }
            return statsCounter;
        }
    }
}

