/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfaster.mango.annotation.Rename;
import org.jfaster.mango.reflect.ParameterDescriptor;

public class NameProvider {
    private Map<Integer, String> namesMap = new HashMap<Integer, String>();
    private Set<String> names = new HashSet<String>();

    public NameProvider(List<ParameterDescriptor> pds) {
        for (ParameterDescriptor pd : pds) {
            Rename renameAnno = pd.getAnnotation(Rename.class);
            int position = pd.getPosition();
            String parameterName = renameAnno != null ? renameAnno.value() : pd.getName();
            this.namesMap.put(position, parameterName);
            this.names.add(parameterName);
        }
    }

    public String getParameterName(int position) {
        String name = this.namesMap.get(position);
        if (name == null) {
            throw new IllegalStateException("parameter name can not be found by position [" + position + "]");
        }
        return name;
    }

    public boolean isParameterName(String name) {
        return this.names.contains(name);
    }
}

