/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.Type;
import java.util.List;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.CacheIgnored;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.annotation.SQL;
import org.jfaster.mango.annotation.ShardBy;
import org.jfaster.mango.annotation.UseMaster;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.exception.IncorrectDefinitionException;
import org.jfaster.mango.exception.IncorrectParameterTypeException;
import org.jfaster.mango.exception.IncorrectSqlException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.BatchUpdateOperator;
import org.jfaster.mango.operator.DataSourceGenerator;
import org.jfaster.mango.operator.InterceptorChain;
import org.jfaster.mango.operator.InvocationContextFactory;
import org.jfaster.mango.operator.InvocationInterceptorChain;
import org.jfaster.mango.operator.NameProvider;
import org.jfaster.mango.operator.Operator;
import org.jfaster.mango.operator.OperatorType;
import org.jfaster.mango.operator.ParameterContext;
import org.jfaster.mango.operator.QueryOperator;
import org.jfaster.mango.operator.TableGenerator;
import org.jfaster.mango.operator.UpdateOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.operator.cache.CacheableBatchUpdateOperator;
import org.jfaster.mango.operator.cache.CacheableQueryOperator;
import org.jfaster.mango.operator.cache.CacheableUpdateOperator;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.parser.SqlParser;
import org.jfaster.mango.partition.DataSourceRouter;
import org.jfaster.mango.partition.IgnoreDataSourceRouter;
import org.jfaster.mango.partition.IgnoreTablePartition;
import org.jfaster.mango.partition.TablePartition;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.reflect.ParameterDescriptor;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.reflect.TypeWrapper;
import org.jfaster.mango.util.SQLType;
import org.jfaster.mango.util.Strings;

public class OperatorFactory {
    private final DataSourceFactory dataSourceFactory;
    private final CacheHandler cacheHandler;
    private final InterceptorChain interceptorChain;

    public OperatorFactory(DataSourceFactory dataSourceFactory, CacheHandler cacheHandler, InterceptorChain interceptorChain) {
        this.dataSourceFactory = dataSourceFactory;
        this.cacheHandler = cacheHandler;
        this.interceptorChain = interceptorChain;
    }

    public Operator getOperator(MethodDescriptor md) {
        AbstractOperator operator;
        boolean useCache;
        OperatorType operatorType;
        SQL sqlAnno = md.getAnnotation(SQL.class);
        if (sqlAnno == null) {
            throw new IllegalStateException("each method expected one @SQL annotation but not found");
        }
        String sql = sqlAnno.value();
        if (Strings.isEmpty(sql)) {
            throw new IncorrectSqlException("sql is null or empty");
        }
        ASTRootNode rootNode = SqlParser.parse(sql).init();
        SQLType sqlType = rootNode.getSQLType();
        List<ParameterDescriptor> pds = md.getParameterDescriptors();
        if (sqlType == SQLType.SELECT) {
            operatorType = OperatorType.QUERY;
        } else {
            ParameterDescriptor pd;
            operatorType = OperatorType.UPDATE;
            if (pds.size() == 1 && (pd = pds.get(0)).isIterable() && rootNode.getJDBCIterableParameters().isEmpty()) {
                operatorType = OperatorType.BATCHUPDATYPE;
            }
        }
        NameProvider nameProvider = new NameProvider(md.getParameterDescriptors());
        ParameterContext context = new ParameterContext(md.getParameterDescriptors(), nameProvider, operatorType);
        rootNode.expandParameter(context);
        rootNode.checkAndBind(context);
        DbInfo dbInfo = this.getDbInfo(md, rootNode, nameProvider, context);
        TableGenerator tableGenerator = new TableGenerator(dbInfo.globalTable, dbInfo.shardParameterName, dbInfo.shardByInvokerGroup, dbInfo.tablePartition);
        DataSourceType dst = DataSourceType.SLAVE;
        if (sqlType.needChangeData() || md.isAnnotationPresent(UseMaster.class)) {
            dst = DataSourceType.MASTER;
        }
        DataSourceGenerator dataSourceGenerator = new DataSourceGenerator(this.dataSourceFactory, dst, dbInfo.dataSourceName, dbInfo.shardParameterName, dbInfo.shardByInvokerGroup, dbInfo.dataSourceRouter);
        CacheIgnored cacheIgnoredAnno = md.getAnnotation(CacheIgnored.class);
        Cache cacheAnno = md.getAnnotation(Cache.class);
        boolean bl = useCache = cacheAnno != null && cacheIgnoredAnno == null;
        if (useCache) {
            CacheDriver driver = new CacheDriver(md, rootNode, this.cacheHandler, context, nameProvider);
            switch (operatorType) {
                case QUERY: {
                    operator = new CacheableQueryOperator(rootNode, md, driver);
                    break;
                }
                case UPDATE: {
                    operator = new CacheableUpdateOperator(rootNode, md, driver);
                    break;
                }
                case BATCHUPDATYPE: {
                    operator = new CacheableBatchUpdateOperator(rootNode, md, driver);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            switch (operatorType) {
                case QUERY: {
                    operator = new QueryOperator(rootNode, md);
                    break;
                }
                case UPDATE: {
                    operator = new UpdateOperator(rootNode, md);
                    break;
                }
                case BATCHUPDATYPE: {
                    operator = new BatchUpdateOperator(rootNode, md);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        InvocationInterceptorChain chain = new InvocationInterceptorChain(this.interceptorChain, context.getParameterDescriptors(), sqlType);
        operator.setTableGenerator(tableGenerator);
        operator.setDataSourceGenerator(dataSourceGenerator);
        operator.setInvocationContextFactory(new InvocationContextFactory(nameProvider));
        operator.setInvocationInterceptorChain(chain);
        return operator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DbInfo getDbInfo(MethodDescriptor md, ASTRootNode rootNode, NameProvider nameProvider, ParameterContext context) {
        DB dbAnno = md.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new IllegalStateException("dao interface expected one @DB annotation but not found");
        }
        String dataSourceName = dbAnno.dataSource();
        String globalTable = null;
        if (Strings.isNotEmpty(dbAnno.table())) {
            globalTable = dbAnno.table();
        }
        Class<? extends TablePartition> tpc = dbAnno.tablePartition();
        TablePartition tablePartition = null;
        if (tpc != null && !tpc.equals(IgnoreTablePartition.class)) {
            tablePartition = Reflection.instantiate(tpc);
        }
        Class<? extends DataSourceRouter> dsrc = dbAnno.dataSourceRouter();
        DataSourceRouter dataSourceRouter = null;
        if (dsrc != null && !dsrc.equals(IgnoreDataSourceRouter.class)) {
            dataSourceRouter = Reflection.instantiate(dsrc);
        }
        if (tablePartition != null && globalTable == null) {
            throw new IncorrectDefinitionException("if @DB.tablePartition is defined, @DB.table must be defined");
        }
        if (tablePartition != null && rootNode.getASTGlobalTables().isEmpty()) {
            throw new IncorrectDefinitionException("if @DB.tablePartition is defined, sql need has one or more #table");
        }
        if (dataSourceRouter != null && tablePartition == null) {
            throw new IncorrectDefinitionException("if @DB.dataSourceRouter is defined, @DB.tablePartition must be defined");
        }
        int shardByNum = 0;
        String shardParameterName = null;
        GetterInvokerGroup shardByInvokerGroup = null;
        String shardParameterProperty = null;
        for (ParameterDescriptor pd : md.getParameterDescriptors()) {
            ShardBy shardByAnno = pd.getAnnotation(ShardBy.class);
            if (shardByAnno == null) continue;
            shardParameterName = nameProvider.getParameterName(pd.getPosition());
            shardParameterProperty = shardByAnno.value();
            ++shardByNum;
        }
        if (tablePartition != null) {
            if (shardByNum != 1) throw new IncorrectDefinitionException("if @DB.tablePartition is defined, need one and only one @ShardBy on method's parameter but found " + shardByNum);
            shardByInvokerGroup = context.getInvokerGroup(shardParameterName, shardParameterProperty);
            Type shardType = shardByInvokerGroup.getFinalType();
            TypeWrapper tw = new TypeWrapper(shardType);
            Class<?> mappedClass = tw.getMappedClass();
            if (mappedClass != null && !tw.isIterable()) return new DbInfo(shardParameterName, shardByInvokerGroup, globalTable, dataSourceName, tablePartition, dataSourceRouter);
            throw new IncorrectParameterTypeException("the type of parameter Modified @ShardBy is error, type is " + shardType);
        }
        if (shardByNum <= 0) return new DbInfo(shardParameterName, shardByInvokerGroup, globalTable, dataSourceName, tablePartition, dataSourceRouter);
        throw new IncorrectDefinitionException("if @DB.tablePartition is not defined, @ShardBy can not on method's parameter but found " + shardByNum);
    }

    static class DbInfo {
        String shardParameterName;
        GetterInvokerGroup shardByInvokerGroup;
        String globalTable;
        String dataSourceName;
        TablePartition tablePartition;
        DataSourceRouter dataSourceRouter;

        DbInfo(String shardParameterName, GetterInvokerGroup shardByInvokerGroup, String globalTable, String dataSourceName, TablePartition tablePartition, DataSourceRouter dataSourceRouter) {
            this.shardParameterName = shardParameterName;
            this.shardByInvokerGroup = shardByInvokerGroup;
            this.globalTable = globalTable;
            this.dataSourceName = dataSourceName;
            this.tablePartition = tablePartition;
            this.dataSourceRouter = dataSourceRouter;
        }
    }
}

