/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.Method;

public class OperatorStats {
    private Method method;
    private final long initCount;
    private final long totalInitTime;
    private final long hitCount;
    private final long missCount;
    private final long executeSuccessCount;
    private final long executeExceptionCount;
    private final long totalExecuteTime;
    private final long evictionCount;

    public OperatorStats(long initCount, long totalInitTime, long hitCount, long missCount, long executeSuccessCount, long executeExceptionCount, long totalExecuteTime, long evictionCount) {
        this.initCount = initCount;
        this.totalInitTime = totalInitTime;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.executeSuccessCount = executeSuccessCount;
        this.executeExceptionCount = executeExceptionCount;
        this.totalExecuteTime = totalExecuteTime;
        this.evictionCount = evictionCount;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public String getMethodNameWithParameterNum() {
        return this.method.getName() + "(" + this.method.getParameterTypes().length + ")";
    }

    public String getClassName() {
        return this.method.getDeclaringClass().getName();
    }

    public String getClassSimpleName() {
        return this.method.getDeclaringClass().getSimpleName();
    }

    public long getAverageInitPenalty() {
        return this.initCount == 0L ? 0L : this.totalInitTime / this.initCount;
    }

    public long getInitCount() {
        return this.initCount;
    }

    public long getTotalInitTime() {
        return this.totalInitTime;
    }

    public long getRequestCount() {
        return this.hitCount + this.missCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public double getHitRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public double getMissRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long getExecuteCount() {
        return this.executeSuccessCount + this.executeExceptionCount;
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public double getExecuteSuccessRate() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 1.0 : (double)this.executeSuccessCount / (double)totalExecuteCount;
    }

    public long getExecuteExceptionCount() {
        return this.executeExceptionCount;
    }

    public double getExecuteExceptionRate() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 0.0 : (double)this.executeExceptionCount / (double)totalExecuteCount;
    }

    public long getTotalExecuteTime() {
        return this.totalExecuteTime;
    }

    public long getAverageExecutePenalty() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 0L : this.totalExecuteTime / totalExecuteCount;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    void setMethod(Method method) {
        this.method = method;
    }
}

