/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.exception.IncorrectParameterCountException;
import org.jfaster.mango.exception.IncorrectParameterTypeException;
import org.jfaster.mango.exception.NotReadableParameterException;
import org.jfaster.mango.invoker.FunctionalGetterInvokerGroup;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.jdbc.JdbcUtils;
import org.jfaster.mango.operator.NameProvider;
import org.jfaster.mango.operator.OperatorType;
import org.jfaster.mango.reflect.ParameterDescriptor;

public class ParameterContext {
    private final List<ParameterDescriptor> parameterDescriptors;
    private final Map<String, Type> typeMap = new HashMap<String, Type>();
    private final Map<String, List<String>> propertyMap = new HashMap<String, List<String>>();

    public ParameterContext(List<ParameterDescriptor> parameterDescriptors, NameProvider nameProvider, OperatorType operatorType) {
        if (operatorType == OperatorType.BATCHUPDATYPE) {
            if (parameterDescriptors.size() != 1) {
                throw new IncorrectParameterCountException("batch update expected one and only one parameter but " + parameterDescriptors.size());
            }
            ParameterDescriptor pd = parameterDescriptors.get(0);
            if (!pd.isIterable()) {
                throw new IncorrectParameterTypeException("parameter of batch update expected array or implementations of java.util.List or implementations of java.util.Set but " + pd.getType());
            }
            parameterDescriptors = new ArrayList<ParameterDescriptor>(1);
            parameterDescriptors.add(new ParameterDescriptor(0, pd.getMappedClass(), pd.getAnnotations(), pd.getName()));
        }
        this.parameterDescriptors = parameterDescriptors;
        for (int i = 0; i < parameterDescriptors.size(); ++i) {
            ParameterDescriptor pd = parameterDescriptors.get(i);
            String parameterName = nameProvider.getParameterName(i);
            this.typeMap.put(parameterName, pd.getType());
            Class<?> parameterRawType = pd.getRawType();
            if (JdbcUtils.isSingleColumnClass(parameterRawType) || pd.isIterable()) continue;
            List<GetterInvoker> invokers = InvokerCache.getGetterInvokers(parameterRawType);
            for (GetterInvoker invoker : invokers) {
                String propertyName = invoker.getName();
                if (nameProvider.isParameterName(propertyName)) continue;
                List<String> oldParameterNames = this.propertyMap.get(propertyName);
                if (oldParameterNames == null) {
                    oldParameterNames = new ArrayList<String>();
                    this.propertyMap.put(propertyName, oldParameterNames);
                }
                oldParameterNames.add(parameterName);
            }
        }
    }

    public GetterInvokerGroup getInvokerGroup(String parameterName, String propertyPath) {
        Type type = this.typeMap.get(parameterName);
        if (type == null) {
            throw new NotReadableParameterException("parameter :" + parameterName + " is not readable");
        }
        FunctionalGetterInvokerGroup invokerGroup = FunctionalGetterInvokerGroup.create(type, parameterName, propertyPath);
        return invokerGroup;
    }

    @Nullable
    public String getParameterNameByPropertyName(String propertyName) {
        List<String> parameterNames = this.propertyMap.get(propertyName);
        if (parameterNames == null) {
            return null;
        }
        if (parameterNames.size() != 1) {
            throw new IllegalArgumentException("parameters " + parameterNames + " has the same property '" + propertyName + "', so can't expand");
        }
        return parameterNames.get(0);
    }

    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameterDescriptors;
    }
}

