/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.HashMap;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.Mapper;
import org.jfaster.mango.annotation.Result;
import org.jfaster.mango.annotation.Results;
import org.jfaster.mango.jdbc.ArrayListSuppliter;
import org.jfaster.mango.jdbc.BeanPropertyRowMapper;
import org.jfaster.mango.jdbc.JdbcUtils;
import org.jfaster.mango.jdbc.LinkedListSuppliter;
import org.jfaster.mango.jdbc.ListSupplier;
import org.jfaster.mango.jdbc.RowMapper;
import org.jfaster.mango.jdbc.SingleColumnRowMapper;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.reflect.ReturnDescriptor;

public class QueryOperator
extends AbstractOperator {
    protected RowMapper<?> rowMapper;
    protected ReturnDescriptor returnDescriptor;
    protected ListSupplier listSupplier;

    protected QueryOperator(ASTRootNode rootNode, MethodDescriptor md) {
        super(rootNode);
        this.init(md);
    }

    private void init(MethodDescriptor md) {
        this.returnDescriptor = md.getReturnDescriptor();
        this.rowMapper = this.getRowMapper(this.returnDescriptor.getMappedClass(), this.returnDescriptor);
        if (this.returnDescriptor.isCollection() || this.returnDescriptor.isList() || this.returnDescriptor.isLinkedList()) {
            this.listSupplier = new LinkedListSuppliter();
        } else if (this.returnDescriptor.isArrayList()) {
            this.listSupplier = new ArrayListSuppliter();
        }
    }

    @Override
    public Object execute(Object[] values) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.execute(context);
    }

    protected Object execute(InvocationContext context) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        DataSource ds = this.dataSourceGenerator.getDataSource(context);
        this.rootNode.render(context);
        PreparedSql preparedSql = context.getPreparedSql();
        this.invocationInterceptorChain.intercept(preparedSql, context);
        String sql = preparedSql.getSql();
        Object[] args = preparedSql.getArgs().toArray();
        return this.executeFromDb(ds, sql, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFromDb(DataSource ds, String sql, Object[] args) {
        Object r;
        boolean success = false;
        long now = System.nanoTime();
        try {
            r = this.returnDescriptor.isCollection() || this.returnDescriptor.isListAssignable() ? this.jdbcOperations.queryForList(ds, sql, args, this.listSupplier, this.rowMapper) : (this.returnDescriptor.isSetAssignable() ? this.jdbcOperations.queryForSet(ds, sql, args, this.rowMapper) : (this.returnDescriptor.isArray() ? this.jdbcOperations.queryForArray(ds, sql, args, this.rowMapper) : this.jdbcOperations.queryForObject(ds, sql, args, this.rowMapper)));
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return r;
    }

    private <T> RowMapper<?> getRowMapper(Class<T> clazz, ReturnDescriptor rd) {
        Result[] resultAnnos;
        Mapper mapperAnno = rd.getAnnotation(Mapper.class);
        Results resultsAnoo = rd.getAnnotation(Results.class);
        if (mapperAnno != null) {
            return Reflection.instantiate(mapperAnno.value());
        }
        if (JdbcUtils.isSingleColumnClass(clazz)) {
            return new SingleColumnRowMapper<T>(clazz);
        }
        HashMap<String, String> ptc = new HashMap<String, String>();
        if (resultsAnoo != null && (resultAnnos = resultsAnoo.value()) != null) {
            for (Result resultAnno : resultAnnos) {
                ptc.put(resultAnno.property().toLowerCase().trim(), resultAnno.column().toLowerCase().trim());
            }
        }
        return new BeanPropertyRowMapper<T>(clazz, ptc);
    }
}

