/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import org.jfaster.mango.operator.OperatorStats;
import org.jfaster.mango.util.concurrent.atomic.LongAddable;
import org.jfaster.mango.util.concurrent.atomic.LongAddables;

public class StatsCounter {
    private volatile RealStatsCounter realStatsCounter = new RealStatsCounter();

    public void recordInit(long initTime) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordInit(initTime);
    }

    public void recordHits(int count) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordHits(count);
    }

    public void recordMisses(int count) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordMisses(count);
    }

    public void recordExecuteSuccess(long executeTime) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordExecuteSuccess(executeTime);
    }

    public void recordExecuteException(long executeTime) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordExecuteException(executeTime);
    }

    public void recordEviction(int count) {
        RealStatsCounter sc = this.realStatsCounter;
        sc.recordEviction(count);
    }

    public OperatorStats snapshot() {
        RealStatsCounter sc = this.realStatsCounter;
        return sc.snapshot();
    }

    public synchronized void reset() {
        RealStatsCounter newSC;
        RealStatsCounter sc = this.realStatsCounter;
        this.realStatsCounter = newSC = new RealStatsCounter(sc.getInitCount(), sc.getTotalInitTime());
    }

    private static class RealStatsCounter {
        private final LongAddable initCount = LongAddables.create();
        private final LongAddable totalInitTime = LongAddables.create();
        private final LongAddable hitCount = LongAddables.create();
        private final LongAddable missCount = LongAddables.create();
        private final LongAddable executeSuccessCount = LongAddables.create();
        private final LongAddable executeExceptionCount = LongAddables.create();
        private final LongAddable totalExecuteTime = LongAddables.create();
        private final LongAddable evictionCount = LongAddables.create();

        public RealStatsCounter() {
        }

        public RealStatsCounter(long initCount, long totalInitTime) {
            this.initCount.add(initCount);
            this.totalInitTime.add(totalInitTime);
        }

        public void recordInit(long initTime) {
            if (initTime >= 0L) {
                this.initCount.increment();
                this.totalInitTime.add(initTime);
            }
        }

        public void recordHits(int count) {
            if (count > 0) {
                this.hitCount.add(count);
            }
        }

        public void recordMisses(int count) {
            if (count > 0) {
                this.missCount.add(count);
            }
        }

        public void recordExecuteSuccess(long executeTime) {
            if (executeTime >= 0L) {
                this.executeSuccessCount.increment();
                this.totalExecuteTime.add(executeTime);
            }
        }

        public void recordExecuteException(long executeTime) {
            if (executeTime >= 0L) {
                this.executeExceptionCount.increment();
                this.totalExecuteTime.add(executeTime);
            }
        }

        public void recordEviction(int count) {
            if (count > 0) {
                this.evictionCount.add(count);
            }
        }

        public OperatorStats snapshot() {
            return new OperatorStats(this.initCount.sum(), this.totalInitTime.sum(), this.hitCount.sum(), this.missCount.sum(), this.executeSuccessCount.sum(), this.executeExceptionCount.sum(), this.totalExecuteTime.sum(), this.evictionCount.sum());
        }

        public long getInitCount() {
            return this.initCount.sum();
        }

        public long getTotalInitTime() {
            return this.totalInitTime.sum();
        }
    }
}

