/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.ReturnGeneratedId;
import org.jfaster.mango.exception.IncorrectReturnTypeException;
import org.jfaster.mango.jdbc.GeneratedKeyHolder;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.PreparedSql;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.util.SQLType;
import org.jfaster.mango.util.ToStringHelper;

public class UpdateOperator
extends AbstractOperator {
    private boolean returnGeneratedId;
    private Transformer transformer;
    private Class<? extends Number> numberRawType;
    private static final Map<Class, Transformer> TRANSFORMERS = new LinkedHashMap<Class, Transformer>();
    private static final Map<Class, GeneratedTransformer> GENERATED_TRANSFORMERS;

    protected UpdateOperator(ASTRootNode rootNode, MethodDescriptor md) {
        super(rootNode);
        this.init(md, rootNode.getSQLType());
    }

    private void init(MethodDescriptor md, SQLType sqlType) {
        ReturnGeneratedId returnGeneratedIdAnno = md.getAnnotation(ReturnGeneratedId.class);
        this.returnGeneratedId = returnGeneratedIdAnno != null && sqlType == SQLType.INSERT;
        Class<?> returnRawType = md.getReturnRawType();
        if (this.returnGeneratedId) {
            GeneratedTransformer gt = GENERATED_TRANSFORMERS.get(returnRawType);
            if (gt == null) {
                String expected = ToStringHelper.toString(GENERATED_TRANSFORMERS.keySet());
                throw new IncorrectReturnTypeException("the return type of update(returnGeneratedId) expected one of " + expected + " but " + returnRawType);
            }
            this.numberRawType = gt.getRawType();
            this.transformer = gt;
        } else {
            this.transformer = TRANSFORMERS.get(returnRawType);
            if (this.transformer == null) {
                String expected = ToStringHelper.toString(TRANSFORMERS.keySet());
                throw new IncorrectReturnTypeException("the return type of update expected one of " + expected + " but " + returnRawType);
            }
        }
    }

    @Override
    public Object execute(Object[] values) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.execute(context);
    }

    public Object execute(InvocationContext context) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        DataSource ds = this.dataSourceGenerator.getDataSource(context);
        this.rootNode.render(context);
        PreparedSql preparedSql = context.getPreparedSql();
        this.invocationInterceptorChain.intercept(preparedSql, context);
        String sql = preparedSql.getSql();
        Object[] args = preparedSql.getArgs().toArray();
        Number r = this.executeDb(ds, sql, args);
        return this.transformer.transform(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number executeDb(DataSource ds, String sql, Object[] args) {
        Number r = null;
        long now = System.nanoTime();
        try {
            if (this.returnGeneratedId) {
                GeneratedKeyHolder holder = new GeneratedKeyHolder(this.numberRawType);
                this.jdbcOperations.update(ds, sql, args, holder);
                r = holder.getKey();
            } else {
                r = this.jdbcOperations.update(ds, sql, args);
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (r != null) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return r;
    }

    static {
        TRANSFORMERS.put(Void.TYPE, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Long.TYPE, LongTransformer.INSTANCE);
        TRANSFORMERS.put(Boolean.TYPE, BooleanTransformer.INSTANCE);
        TRANSFORMERS.put(Void.class, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Long.class, LongTransformer.INSTANCE);
        TRANSFORMERS.put(Boolean.class, BooleanTransformer.INSTANCE);
        GENERATED_TRANSFORMERS = new LinkedHashMap<Class, GeneratedTransformer>();
        GENERATED_TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Long.TYPE, LongTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Long.class, LongTransformer.INSTANCE);
    }

    static enum BooleanTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static enum VoidTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return null;
        }
    }

    static enum LongTransformer implements GeneratedTransformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.longValue();
        }

        @Override
        public Class<? extends Number> getRawType() {
            return Long.TYPE;
        }
    }

    static enum IntegerTransformer implements GeneratedTransformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.intValue();
        }

        @Override
        public Class<? extends Number> getRawType() {
            return Integer.TYPE;
        }
    }

    static interface GeneratedTransformer
    extends Transformer {
        public Class<? extends Number> getRawType();
    }

    static interface Transformer {
        public Object transform(Number var1);
    }
}

