/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.CacheBy;
import org.jfaster.mango.annotation.CacheIgnored;
import org.jfaster.mango.exception.IncorrectCacheByException;
import org.jfaster.mango.exception.IncorrectDefinitionException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.NameProvider;
import org.jfaster.mango.operator.ParameterContext;
import org.jfaster.mango.operator.cache.CacheBase;
import org.jfaster.mango.operator.cache.CacheExpire;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.operator.cache.CacheMultiKey;
import org.jfaster.mango.operator.cache.CacheSingleKey;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTJDBCParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.reflect.ParameterDescriptor;
import org.jfaster.mango.reflect.Reflection;
import org.jfaster.mango.reflect.TypeWrapper;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.Strings;

public class CacheDriver
implements CacheBase,
CacheSingleKey,
CacheMultiKey {
    private CacheHandler cacheHandler;
    private NameProvider nameProvider;
    private String prefix;
    private CacheExpire cacheExpire;
    private int expireNum;
    private List<CacheByItem> cacheByItems = new ArrayList<CacheByItem>();
    private boolean useMultipleKeys;
    private String propertyOfMapper;

    public CacheDriver(MethodDescriptor md, ASTRootNode rootNode, CacheHandler cacheHandler, ParameterContext context, NameProvider nameProvider) {
        this.cacheHandler = cacheHandler;
        this.nameProvider = nameProvider;
        this.init(md, rootNode, context);
    }

    @Override
    public boolean isUseMultipleKeys() {
        return this.useMultipleKeys;
    }

    @Override
    public void setToCache(String key, Object value) {
        this.cacheHandler.set(key, value, this.cacheExpire.getExpireTime() * this.expireNum);
    }

    @Override
    public void deleteFromCache(String key) {
        this.cacheHandler.delete(key);
    }

    @Override
    public void deleteFromCache(Set<String> keys) {
        if (keys.size() > 0) {
            this.cacheHandler.delete(keys);
        }
    }

    @Override
    public Object getFromCache(String key) {
        Object value = this.cacheHandler.get(key);
        return value;
    }

    @Override
    @Nullable
    public Map<String, Object> getBulkFromCache(Set<String> keys) {
        if (keys.size() > 0) {
            Map<String, Object> values = this.cacheHandler.getBulk(keys);
            return values;
        }
        return null;
    }

    @Override
    public String getCacheKey(InvocationContext context) {
        StringBuilder key = new StringBuilder(this.prefix);
        for (CacheByItem item : this.cacheByItems) {
            Object obj = context.getPropertyValue(item.getParameterName(), item.getInvokerGroup());
            if (obj == null) {
                throw new NullPointerException("value of " + item.getFullName() + " can't be null");
            }
            key.append("_").append(obj);
        }
        return key.toString();
    }

    @Override
    public Class<?> getOnlyCacheByClass() {
        return CacheDriver.getOnlyCacheByItem(this.cacheByItems).getActualClass();
    }

    @Override
    public Set<String> getCacheKeys(InvocationContext context) {
        Iterables iterables = new Iterables(this.getOnlyCacheByObj(context));
        if (iterables.isEmpty()) {
            CacheByItem item = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
            throw new IllegalArgumentException("value of " + item.getFullName() + " can't be empty");
        }
        HashSet<String> keys = new HashSet<String>(iterables.size() * 2);
        for (Object obj : iterables) {
            String key = this.getCacheKey(obj);
            keys.add(key);
        }
        return keys;
    }

    @Override
    public String getCacheKey(Object obj) {
        return this.prefix + "_" + obj;
    }

    @Override
    public Object getOnlyCacheByObj(InvocationContext context) {
        CacheByItem item = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
        Object obj = context.getPropertyValue(item.getParameterName(), item.getInvokerGroup());
        if (obj == null) {
            throw new NullPointerException("value of " + item.getFullName() + " can't be null");
        }
        return obj;
    }

    @Override
    public void setOnlyCacheByObj(InvocationContext context, Object obj) {
        CacheByItem item = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
        context.setPropertyValue(item.getParameterName(), item.getInvokerGroup(), obj);
    }

    @Override
    public String getPropertyOfMapper() {
        return this.propertyOfMapper;
    }

    private void init(MethodDescriptor md, ASTRootNode rootNode, ParameterContext context) {
        for (ParameterDescriptor pd : md.getParameterDescriptors()) {
            CacheBy cacheByAnno = pd.getAnnotation(CacheBy.class);
            if (cacheByAnno == null) continue;
            String parameterName = this.nameProvider.getParameterName(pd.getPosition());
            String propertyPaths = cacheByAnno.value();
            for (String propertyPath : propertyPaths.split(",")) {
                propertyPath = propertyPath.trim();
                GetterInvokerGroup invokerGroup = context.getInvokerGroup(parameterName, propertyPath);
                Type cacheByType = invokerGroup.getFinalType();
                TypeWrapper tw = new TypeWrapper(cacheByType);
                this.cacheByItems.add(new CacheByItem(parameterName, propertyPath, tw.getMappedClass(), invokerGroup));
                this.useMultipleKeys = this.useMultipleKeys || tw.isIterable();
            }
        }
        int cacheByNum = this.cacheByItems.size();
        if (this.useMultipleKeys && cacheByNum > 1) {
            throw new IncorrectCacheByException("when @CacheBy modification interable parameter, there can be only one @CacheBy");
        }
        Cache cacheAnno = md.getAnnotation(Cache.class);
        CacheIgnored cacheIgnoredAnno = md.getAnnotation(CacheIgnored.class);
        if (cacheAnno != null) {
            if (cacheIgnoredAnno == null) {
                if (cacheByNum == 0) {
                    throw new IllegalStateException("if use cache, each method expected one or more @CacheBy annotation on parameter but found 0");
                }
                this.prefix = cacheAnno.prefix();
                this.cacheExpire = Reflection.instantiate(cacheAnno.expire());
                this.expireNum = cacheAnno.num();
                CacheDriver.checkCacheBy(rootNode, this.cacheByItems);
            } else if (cacheByNum > 0) {
                throw new IncorrectDefinitionException("if @CacheIgnored is on method, @CacheBy can not on method's parameter");
            }
        } else {
            if (cacheByNum > 0) {
                throw new IncorrectDefinitionException("if @Cache is not defined, @CacheBy can not on method's parameter");
            }
            if (cacheIgnoredAnno != null) {
                throw new IncorrectDefinitionException("if @Cache is not defined, @CacheIgnored can not on method");
            }
        }
        if (this.useMultipleKeys) {
            CacheByItem cacheByItem = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
            for (ASTJDBCIterableParameter jip : rootNode.getJDBCIterableParameters()) {
                if (!jip.getParameterName().equals(cacheByItem.getParameterName()) || !jip.getPropertyPath().equals(cacheByItem.getPropertyPath())) continue;
                this.propertyOfMapper = jip.getPropertyOfMapper();
                break;
            }
        }
    }

    private static CacheByItem getOnlyCacheByItem(List<CacheByItem> cacheByItems) {
        if (cacheByItems.size() != 1) {
            throw new IllegalStateException("size of cacheByItems expected 1 but " + cacheByItems.size());
        }
        return cacheByItems.get(0);
    }

    private static void checkCacheBy(ASTRootNode rootNode, List<CacheByItem> cacheByItems) {
        List<ASTJDBCParameter> jps = rootNode.getJDBCParameters();
        for (CacheByItem cacheByItem : cacheByItems) {
            String parameterName = cacheByItem.getParameterName();
            String propertyPath = cacheByItem.getPropertyPath();
            boolean pass = false;
            for (ASTJDBCParameter jp : jps) {
                if (!jp.getParameterName().equals(parameterName) || !jp.getPropertyPath().equals(propertyPath)) continue;
                pass = true;
                break;
            }
            List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
            for (ASTJDBCIterableParameter jip : jips) {
                if (!jip.getParameterName().equals(parameterName) || !jip.getPropertyPath().equals(propertyPath)) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            throw new IncorrectCacheByException("CacheBy " + cacheByItem.getFullName() + " can't match any db parameter");
        }
    }

    private static class CacheByItem {
        private final String parameterName;
        private final String propertyPath;
        private final Class<?> actualClass;
        private final GetterInvokerGroup invokerGroup;

        public CacheByItem(String parameterName, String propertyPath, Class<?> actualClass, GetterInvokerGroup invokerGroup) {
            this.parameterName = parameterName;
            this.propertyPath = propertyPath;
            this.actualClass = actualClass;
            this.invokerGroup = invokerGroup;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        private Class<?> getActualClass() {
            return this.actualClass;
        }

        private GetterInvokerGroup getInvokerGroup() {
            return this.invokerGroup;
        }

        public String getFullName() {
            return Strings.getFullName(this.parameterName, this.propertyPath);
        }
    }
}

