/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.HashMap;
import java.util.HashSet;
import javax.sql.DataSource;
import org.jfaster.mango.operator.BatchUpdateOperator;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableBatchUpdateOperator
extends BatchUpdateOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableBatchUpdateOperator.class);
    private CacheDriver driver;

    public CacheableBatchUpdateOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver) {
        super(rootNode, md);
        this.driver = cacheDriver;
    }

    @Override
    public Object execute(Object[] values) {
        Object firstValue = values[0];
        if (firstValue == null) {
            throw new NullPointerException("batchUpdate's parameter can't be null");
        }
        Iterables iterables = new Iterables(firstValue);
        if (iterables.isEmpty()) {
            throw new IllegalArgumentException("batchUpdate's parameter can't be empty");
        }
        HashSet<String> keys = new HashSet<String>(iterables.size() * 2);
        HashMap<DataSource, BatchUpdateOperator.Group> groupMap = new HashMap<DataSource, BatchUpdateOperator.Group>();
        int t = 0;
        for (Object obj : iterables) {
            InvocationContext context = this.invocationContextFactory.newInvocationContext(new Object[]{obj});
            keys.add(this.driver.getCacheKey(context));
            this.group(context, groupMap, t++);
        }
        int[] ints = this.executeDb(groupMap, t);
        if (logger.isDebugEnabled()) {
            logger.debug("cache delete #keys={}", (Object)keys);
        }
        this.driver.deleteFromCache(keys);
        this.statsCounter.recordEviction(keys.size());
        return this.transformer.transform(ints);
    }
}

