/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfaster.mango.exception.IncorrectSqlException;
import org.jfaster.mango.exception.NotReadablePropertyException;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.QueryOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.operator.cache.CacheableUpdateOperator;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.util.Arrays;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableQueryOperator
extends QueryOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableUpdateOperator.class);
    private CacheDriver driver;
    GetterInvoker propertyOfMapperInvoker;

    public CacheableQueryOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver) {
        super(rootNode, md);
        this.driver = cacheDriver;
        List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
        if (jips.size() > 1) {
            throw new IncorrectSqlException("if use cache, sql's in clause expected less than or equal 1 but " + jips.size());
        }
        if (this.driver.isUseMultipleKeys()) {
            String propertyOfMapper = this.driver.getPropertyOfMapper().toLowerCase();
            List<GetterInvoker> invokers = InvokerCache.getGetterInvokers(this.returnDescriptor.getMappedClass());
            for (GetterInvoker invoker : invokers) {
                if (!Strings.underscoreName(invoker.getName()).equals(propertyOfMapper)) continue;
                this.propertyOfMapperInvoker = invoker;
            }
            if (this.propertyOfMapperInvoker == null) {
                throw new NotReadablePropertyException("if use cache and sql has one in clause, property " + propertyOfMapper + " of " + this.returnDescriptor.getMappedClass() + " expected readable but not");
            }
        }
    }

    @Override
    public Object execute(Object[] values) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.driver.isUseMultipleKeys() ? this.multipleKeysCache(context, this.rowMapper.getMappedClass(), this.driver.getOnlyCacheByClass()) : this.singleKeyCache(context);
    }

    private <T, U> Object multipleKeysCache(InvocationContext context, Class<T> mappedClass, Class<U> cacheByActualClass) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Set<String> keys = this.driver.getCacheKeys(context);
        Map<String, Object> cachedResults = this.driver.getBulkFromCache(keys);
        AddableObject<T> addableObj = new AddableObject<T>(keys.size(), mappedClass);
        int hitCapacity = cachedResults != null ? cachedResults.size() : 0;
        ArrayList<U> hitCacheByActualObjs = new ArrayList<U>(hitCapacity);
        int hitNum = 0;
        HashSet<U> missCacheByActualObjs = new HashSet<U>(Math.max(1, keys.size() - hitCapacity) * 2);
        for (Object cacheByActualObj : new Iterables(this.driver.getOnlyCacheByObj(context))) {
            Object value;
            String key = this.driver.getCacheKey(cacheByActualObj);
            Object object = value = cachedResults != null ? cachedResults.get(key) : null;
            if (value == null) {
                missCacheByActualObjs.add(cacheByActualClass.cast(cacheByActualObj));
                continue;
            }
            addableObj.add(mappedClass.cast(value));
            ++hitNum;
            if (!isDebugEnabled) continue;
            hitCacheByActualObjs.add(cacheByActualClass.cast(cacheByActualObj));
        }
        this.statsCounter.recordHits(hitNum);
        this.statsCounter.recordMisses(missCacheByActualObjs.size());
        if (isDebugEnabled) {
            logger.debug("cache hit #keys={} #values={}", (Object)hitCacheByActualObjs, (Object)addableObj);
            logger.debug("cache miss #keys={}", (Object)missCacheByActualObjs);
        }
        if (!missCacheByActualObjs.isEmpty()) {
            this.driver.setOnlyCacheByObj(context, missCacheByActualObjs);
            Object dbValues = this.execute(context);
            for (Object dbValue : new Iterables(dbValues)) {
                addableObj.add(mappedClass.cast(dbValue));
                Object propertyObj = this.propertyOfMapperInvoker.invoke(dbValue);
                if (propertyObj == null) {
                    throw new NullPointerException("property " + this.propertyOfMapperInvoker.getName() + " of " + mappedClass + " is null, please check return type");
                }
                String key = this.driver.getCacheKey(propertyObj);
                this.driver.setToCache(key, dbValue);
            }
        }
        return addableObj.getReturn();
    }

    private Object singleKeyCache(InvocationContext context) {
        String key = this.driver.getCacheKey(context);
        Object value = this.driver.getFromCache(key);
        if (value == null) {
            this.statsCounter.recordMisses(1);
            if (logger.isDebugEnabled()) {
                logger.debug("cache miss #key\uff1d{}", (Object)key);
            }
            if ((value = this.execute(context)) != null) {
                this.driver.setToCache(key, value);
            }
        } else {
            this.statsCounter.recordHits(1);
            if (logger.isDebugEnabled()) {
                logger.debug("cache hit #key={} #value={}", (Object)key, value);
            }
        }
        return value;
    }

    private class AddableObject<T> {
        List<T> hitValueList;
        Set<T> hitValueSet;
        Class<T> valueClass;

        private AddableObject(int initialCapacity, Class<T> valueClass) {
            if (CacheableQueryOperator.this.returnDescriptor.isSetAssignable()) {
                this.hitValueSet = new HashSet<T>(initialCapacity * 2);
            } else {
                this.hitValueList = CacheableQueryOperator.this.returnDescriptor.isArrayList() ? new ArrayList<T>(initialCapacity) : new LinkedList<T>();
            }
            this.valueClass = valueClass;
        }

        public void add(T v) {
            if (this.hitValueList != null) {
                this.hitValueList.add(v);
            } else {
                this.hitValueSet.add(v);
            }
        }

        public Object getReturn() {
            if (CacheableQueryOperator.this.returnDescriptor.isListAssignable() || CacheableQueryOperator.this.returnDescriptor.isCollection()) {
                return this.hitValueList;
            }
            if (CacheableQueryOperator.this.returnDescriptor.isSetAssignable()) {
                return this.hitValueSet;
            }
            if (CacheableQueryOperator.this.returnDescriptor.isArray()) {
                return Arrays.toArray(this.hitValueList, this.valueClass);
            }
            return !this.hitValueList.isEmpty() ? this.hitValueList.get(0) : null;
        }

        public String toString() {
            return this.hitValueList != null ? this.hitValueList.toString() : this.hitValueSet.toString();
        }
    }
}

