/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.List;
import java.util.Set;
import org.jfaster.mango.exception.IncorrectSqlException;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.operator.UpdateOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.reflect.MethodDescriptor;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableUpdateOperator
extends UpdateOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableUpdateOperator.class);
    private CacheDriver driver;

    public CacheableUpdateOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver) {
        super(rootNode, md);
        this.driver = cacheDriver;
        List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
        if (jips.size() > 1) {
            throw new IncorrectSqlException("if use cache, sql's in clause expected less than or equal 1 but " + jips.size());
        }
    }

    @Override
    public Object execute(Object[] values) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        Object r = this.execute(context);
        if (this.driver.isUseMultipleKeys()) {
            Set<String> keys = this.driver.getCacheKeys(context);
            if (logger.isDebugEnabled()) {
                logger.debug("cache delete #keys={}", (Object)keys);
            }
            this.driver.deleteFromCache(keys);
            this.statsCounter.recordEviction(keys.size());
        } else {
            String key = this.driver.getCacheKey(context);
            if (logger.isDebugEnabled()) {
                logger.debug("cache delete #key={}", (Object)key);
            }
            this.driver.deleteFromCache(key);
            this.statsCounter.recordEviction(1);
        }
        return r;
    }
}

