/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.exception.UnreachableCodeException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.parser.AbstractExpression;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;
import org.jfaster.mango.util.Strings;

public class ASTExpressionParameter
extends AbstractExpression
implements ParameterBean {
    private String parameterName;
    private String propertyPath;
    private GetterInvokerGroup invokerGroup;

    public ASTExpressionParameter(int i) {
        super(i);
    }

    public ASTExpressionParameter(Parser p, int i) {
        super(p, i);
    }

    public void init(String str) {
        Pattern p = Pattern.compile(":(\\w+)(\\.\\w+)*");
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        this.parameterName = m.group(1);
        this.propertyPath = str.substring(m.end(1));
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
    }

    @Override
    public boolean evaluate(InvocationContext context) {
        if (this.invokerGroup == null) {
            throw new NullPointerException("invoker must set");
        }
        Object obj = context.getNullablePropertyValue(this.parameterName, this.invokerGroup);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return !((String)obj).isEmpty();
        }
        return obj != null;
    }

    @Override
    public Object value(InvocationContext context) {
        if (this.invokerGroup == null) {
            throw new NullPointerException("invoker must set");
        }
        return context.getNullablePropertyValue(this.parameterName, this.invokerGroup);
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "fullName=" + this.getFullName() + ", " + "parameterName=" + this.parameterName + ", " + "propertyPath=" + this.propertyPath + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean hasProperty() {
        return Strings.isNotEmpty(this.propertyPath);
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    @Override
    public String getFullName() {
        return Strings.getFullName(this.parameterName, this.propertyPath);
    }

    @Override
    public void setInvokerGroup(GetterInvokerGroup invokerGroup) {
        this.invokerGroup = invokerGroup;
    }
}

