/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.exception.UnreachableCodeException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.parser.AbstractRenderableNode;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.Strings;

public class ASTJDBCIterableParameter
extends AbstractRenderableNode
implements ParameterBean {
    private String parameterName;
    private String propertyPath;
    private GetterInvokerGroup invokerGroup;
    private String propertyOfMapper;

    public ASTJDBCIterableParameter(int i) {
        super(i);
    }

    public ASTJDBCIterableParameter(Parser p, int i) {
        super(p, i);
    }

    public void init(String str) {
        Pattern p = Pattern.compile("in\\s*\\(\\s*(:(\\w+)(\\.\\w+)*)\\s*\\)", 2);
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        String fullName = m.group(1);
        this.parameterName = m.group(2);
        this.propertyPath = fullName.substring(this.parameterName.length() + 1);
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
    }

    @Override
    public boolean render(InvocationContext context) {
        if (this.invokerGroup == null) {
            throw new NullPointerException("invoker must set");
        }
        Object objs = context.getNullablePropertyValue(this.parameterName, this.invokerGroup);
        if (objs == null) {
            throw new NullPointerException("value of " + Strings.getFullName(this.parameterName, this.propertyPath) + " can't be null");
        }
        Iterables iterables = new Iterables(objs);
        if (iterables.isEmpty()) {
            throw new IllegalArgumentException("value of " + Strings.getFullName(this.parameterName, this.propertyPath) + " can't be empty");
        }
        context.writeToSqlBuffer("in (");
        int t = 0;
        for (Object obj : iterables) {
            context.appendToArgs(obj);
            if (t == 0) {
                context.writeToSqlBuffer("?");
            } else {
                context.writeToSqlBuffer(",?");
            }
            ++t;
        }
        context.writeToSqlBuffer(")");
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "fullName=" + this.getFullName() + ", " + "parameterName=" + this.parameterName + ", " + "propertyPath=" + this.propertyPath + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean hasProperty() {
        return Strings.isNotEmpty(this.propertyPath);
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    @Override
    public String getFullName() {
        return Strings.getFullName(this.parameterName, this.propertyPath);
    }

    @Override
    public void setInvokerGroup(GetterInvokerGroup invokerGroup) {
        this.invokerGroup = invokerGroup;
    }

    public String getPropertyOfMapper() {
        return this.propertyOfMapper;
    }

    public void setPropertyOfMapper(String propertyOfMapper) {
        this.propertyOfMapper = propertyOfMapper;
    }
}

