/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.exception.UnreachableCodeException;
import org.jfaster.mango.invoker.GetterInvokerGroup;
import org.jfaster.mango.operator.InvocationContext;
import org.jfaster.mango.parser.AbstractRenderableNode;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;
import org.jfaster.mango.util.Strings;

public class ASTJoinParameter
extends AbstractRenderableNode
implements ParameterBean {
    private String parameterName;
    private String propertyPath;
    private GetterInvokerGroup invokerGroup;

    public ASTJoinParameter(int id) {
        super(id);
    }

    public ASTJoinParameter(Parser p, int id) {
        super(p, id);
    }

    public void init(String str) {
        Pattern p = Pattern.compile("#\\{\\s*(:(\\w+)(\\.\\w+)*)\\s*\\}", 2);
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        String fullName = m.group(1);
        this.parameterName = m.group(2);
        this.propertyPath = fullName.substring(this.parameterName.length() + 1);
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
    }

    @Override
    public boolean render(InvocationContext context) {
        if (this.invokerGroup == null) {
            throw new NullPointerException("invoker chain must set");
        }
        Object obj = context.getPropertyValue(this.parameterName, this.invokerGroup);
        context.writeToSqlBuffer(obj.toString());
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "fullName=" + this.getFullName() + ", " + "parameterName=" + this.parameterName + ", " + "propertyPath=" + this.propertyPath + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean hasProperty() {
        return Strings.isNotEmpty(this.propertyPath);
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    @Override
    public String getFullName() {
        return Strings.getFullName(this.parameterName, this.propertyPath);
    }

    @Override
    public void setInvokerGroup(GetterInvokerGroup invokerGroup) {
        this.invokerGroup = invokerGroup;
    }
}

