/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.plugin.spring.DefaultMangoFactoryBean;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public final class MangoConfigurer
implements BeanFactoryPostProcessor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MangoConfigurer.class);
    private static final List<String> DAO_ENDS = Arrays.asList("Dao", "DAO");
    List<String> locationPatterns = new ArrayList<String>();
    Class<?> factoryBeanClass = DefaultMangoFactoryBean.class;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        for (Class<?> daoClass : this.findMangoDaoClasses()) {
            GenericBeanDefinition bf = new GenericBeanDefinition();
            bf.setBeanClassName(daoClass.getName());
            MutablePropertyValues pvs = bf.getPropertyValues();
            pvs.addPropertyValue("daoClass", daoClass);
            bf.setBeanClass(this.factoryBeanClass);
            bf.setPropertyValues(pvs);
            bf.setLazyInit(false);
            dlbf.registerBeanDefinition(daoClass.getName(), (BeanDefinition)bf);
        }
    }

    private List<Class<?>> findMangoDaoClasses() {
        try {
            ArrayList daos = new ArrayList();
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (String locationPattern : this.locationPatterns) {
                Resource[] rs;
                for (Resource r : rs = resourcePatternResolver.getResources(locationPattern)) {
                    MetadataReader reader = metadataReaderFactory.getMetadataReader(r);
                    AnnotationMetadata annotationMD = reader.getAnnotationMetadata();
                    if (!annotationMD.hasAnnotation(DB.class.getName())) continue;
                    ClassMetadata clazzMD = reader.getClassMetadata();
                    daos.add(Class.forName(clazzMD.getClassName()));
                }
            }
            return daos;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void setPackages(List<String> packages) {
        for (String p : packages) {
            for (String daoEnd : DAO_ENDS) {
                String locationPattern = "classpath*:" + p.replaceAll("\\.", "/") + "/**/*" + daoEnd + ".class";
                logger.info("trnas package[" + p + "] to locationPattern[" + locationPattern + "]");
                this.locationPatterns.add(locationPattern);
            }
        }
    }

    public void setFactoryBeanClass(Class<?> factoryBeanClass) {
        this.factoryBeanClass = factoryBeanClass;
    }
}

