/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.stats;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.plugin.stats.StatsRender;

public class MangoStatsServlet
extends HttpServlet {
    private static final String KEY_NAME = "key";
    private String key;

    public void init(ServletConfig config) throws ServletException {
        this.key = config.getInitParameter(KEY_NAME);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("content-type", "text/html;charset=UTF-8");
        PrintWriter out = resp.getWriter();
        try {
            Class.forName("freemarker.template.Template");
        }
        catch (ClassNotFoundException e) {
            out.println("need freemarker");
            out.flush();
            return;
        }
        String pKey = req.getParameter(KEY_NAME);
        if (this.key != null && !this.key.equals(pKey)) {
            resp.setStatus(404);
            out.println("404");
            out.flush();
            return;
        }
        try {
            String type = req.getParameter("type");
            if ("reset".equals(type)) {
                List<Mango> mangos = Mango.getInstances();
                if (mangos.size() != 1) {
                    throw new IllegalStateException("instance of mango expected 1 but " + mangos.size());
                }
                mangos.get(0).resetAllStats();
                String url = req.getRequestURL().toString();
                if (this.key != null) {
                    url = url + "?" + KEY_NAME + "=" + this.key;
                }
                resp.sendRedirect(url);
                return;
            }
            out.println(StatsRender.getHtml(Boolean.valueOf(req.getParameter("all")), this.key));
            out.flush();
        }
        catch (Exception e) {
            out.println(e.getMessage());
            out.flush();
        }
    }
}

