/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.reflect.ParameterDescriptor;
import org.jfaster.mango.reflect.ReturnDescriptor;

public class MethodDescriptor {
    private final ReturnDescriptor returnDescriptor;
    private final List<ParameterDescriptor> parameterDescriptors;

    public MethodDescriptor(ReturnDescriptor returnDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        this.returnDescriptor = returnDescriptor;
        this.parameterDescriptors = Collections.unmodifiableList(parameterDescriptors);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.returnDescriptor.getAnnotation(annotationType);
    }

    public Type getReturnType() {
        return this.returnDescriptor.getType();
    }

    public Class<?> getReturnRawType() {
        return this.returnDescriptor.getRawType();
    }

    public List<Annotation> getAnnotations() {
        return this.returnDescriptor.getAnnotations();
    }

    public ReturnDescriptor getReturnDescriptor() {
        return this.returnDescriptor;
    }

    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameterDescriptors;
    }
}

