/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.reflect.ParameterDescriptor;

public class Parameter {
    private final ParameterDescriptor descriptor;
    private final Object value;

    public Parameter(ParameterDescriptor descriptor, Object value) {
        this.descriptor = descriptor;
        this.value = value;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.descriptor.getType();
    }

    public Class<?> getRawType() {
        return this.descriptor.getRawType();
    }

    public List<Annotation> getAnnotations() {
        return this.descriptor.getAnnotations();
    }
}

