/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.reflect;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.reflect.TypeCapture;
import org.jfaster.mango.reflect.TypeResolver;
import org.jfaster.mango.reflect.TypeVisitor;
import org.jfaster.mango.reflect.Types;
import org.jfaster.mango.util.Primitives;

public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType;
    private transient TypeResolver typeResolver;

    protected TypeToken() {
        this.runtimeType = this.capture();
        if (this.runtimeType instanceof TypeVariable) {
            throw new IllegalStateException(String.format("Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", this.runtimeType));
        }
    }

    private TypeToken(Type type) {
        this.runtimeType = type;
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        return new SimpleTypeToken(type);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public final Class<? super T> getRawType() {
        Class<?> rawType;
        Class<?> result = rawType = TypeToken.getRawType(this.runtimeType);
        return result;
    }

    public final Type getType() {
        return this.runtimeType;
    }

    private final TypeToken<?> resolveType(Type type) {
        TypeResolver resolver = this.typeResolver;
        if (resolver == null) {
            resolver = this.typeResolver = TypeResolver.accordingTo(this.runtimeType);
        }
        return TypeToken.of(resolver.resolveType(type));
    }

    public final boolean isAssignableFrom(TypeToken<?> type) {
        return this.isAssignableFrom(type.runtimeType);
    }

    public final boolean isAssignableFrom(Type type) {
        return TypeToken.isAssignable(type, this.runtimeType);
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final boolean isPrimitive() {
        return this.runtimeType instanceof Class && ((Class)this.runtimeType).isPrimitive();
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            Class type = (Class)this.runtimeType;
            return TypeToken.of(Primitives.wrap(type));
        }
        return this;
    }

    @Nullable
    public final TypeToken<?> getComponentType() {
        Type componentType = Types.getComponentType(this.runtimeType);
        if (componentType == null) {
            return null;
        }
        return TypeToken.of(componentType);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TypeToken) {
            TypeToken that = (TypeToken)o;
            return this.runtimeType.equals(that.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    private static boolean isAssignable(Type from, Type to) {
        if (to.equals(from)) {
            return true;
        }
        if (to instanceof WildcardType) {
            return TypeToken.isAssignableToWildcardType(from, (WildcardType)to);
        }
        if (from instanceof TypeVariable) {
            return TypeToken.isAssignableFromAny(((TypeVariable)from).getBounds(), to);
        }
        if (from instanceof WildcardType) {
            return TypeToken.isAssignableFromAny(((WildcardType)from).getUpperBounds(), to);
        }
        if (from instanceof GenericArrayType) {
            return TypeToken.isAssignableFromGenericArrayType((GenericArrayType)from, to);
        }
        if (to instanceof Class) {
            return TypeToken.isAssignableToClass(from, (Class)to);
        }
        if (to instanceof ParameterizedType) {
            return TypeToken.isAssignableToParameterizedType(from, (ParameterizedType)to);
        }
        if (to instanceof GenericArrayType) {
            return TypeToken.isAssignableToGenericArrayType(from, (GenericArrayType)to);
        }
        return false;
    }

    private static boolean isAssignableFromAny(Type[] fromTypes, Type to) {
        for (Type from : fromTypes) {
            if (!TypeToken.isAssignable(from, to)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableToClass(Type from, Class<?> to) {
        return to.isAssignableFrom(TypeToken.getRawType(from));
    }

    private static boolean isAssignableToWildcardType(Type from, WildcardType to) {
        return TypeToken.isAssignable(from, TypeToken.supertypeBound(to)) && TypeToken.isAssignableBySubtypeBound(from, to);
    }

    private static boolean isAssignableBySubtypeBound(Type from, WildcardType to) {
        Type toSubtypeBound = TypeToken.subtypeBound(to);
        if (toSubtypeBound == null) {
            return true;
        }
        Type fromSubtypeBound = TypeToken.subtypeBound(from);
        if (fromSubtypeBound == null) {
            return false;
        }
        return TypeToken.isAssignable(toSubtypeBound, fromSubtypeBound);
    }

    private static boolean isAssignableToParameterizedType(Type from, ParameterizedType to) {
        Class<?> matchedClass = TypeToken.getRawType(to);
        if (!matchedClass.isAssignableFrom(TypeToken.getRawType(from))) {
            return false;
        }
        TypeVariable<Class<?>>[] typeParams = matchedClass.getTypeParameters();
        Type[] toTypeArgs = to.getActualTypeArguments();
        TypeToken<?> fromTypeToken = TypeToken.of(from);
        for (int i = 0; i < typeParams.length; ++i) {
            Type fromTypeArg = super.resolveType(typeParams[i]).runtimeType;
            if (TypeToken.matchTypeArgument(fromTypeArg, toTypeArgs[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableToGenericArrayType(Type from, GenericArrayType to) {
        if (from instanceof Class) {
            Class fromClass = (Class)from;
            if (!fromClass.isArray()) {
                return false;
            }
            return TypeToken.isAssignable(fromClass.getComponentType(), to.getGenericComponentType());
        }
        if (from instanceof GenericArrayType) {
            GenericArrayType fromArrayType = (GenericArrayType)from;
            return TypeToken.isAssignable(fromArrayType.getGenericComponentType(), to.getGenericComponentType());
        }
        return false;
    }

    private static boolean isAssignableFromGenericArrayType(GenericArrayType from, Type to) {
        if (to instanceof Class) {
            Class toClass = (Class)to;
            if (!toClass.isArray()) {
                return toClass == Object.class;
            }
            return TypeToken.isAssignable(from.getGenericComponentType(), toClass.getComponentType());
        }
        if (to instanceof GenericArrayType) {
            GenericArrayType toArrayType = (GenericArrayType)to;
            return TypeToken.isAssignable(from.getGenericComponentType(), toArrayType.getGenericComponentType());
        }
        return false;
    }

    private static boolean matchTypeArgument(Type from, Type to) {
        if (from.equals(to)) {
            return true;
        }
        if (to instanceof WildcardType) {
            return TypeToken.isAssignableToWildcardType(from, (WildcardType)to);
        }
        return false;
    }

    private static Type supertypeBound(Type type) {
        if (type instanceof WildcardType) {
            return TypeToken.supertypeBound((WildcardType)type);
        }
        return type;
    }

    private static Type supertypeBound(WildcardType type) {
        Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length == 1) {
            return TypeToken.supertypeBound(upperBounds[0]);
        }
        if (upperBounds.length == 0) {
            return Object.class;
        }
        throw new AssertionError((Object)("There should be at most one upper bound for wildcard type: " + type));
    }

    @Nullable
    private static Type subtypeBound(Type type) {
        if (type instanceof WildcardType) {
            return TypeToken.subtypeBound((WildcardType)type);
        }
        return type;
    }

    @Nullable
    private static Type subtypeBound(WildcardType type) {
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 1) {
            return TypeToken.subtypeBound(lowerBounds[0]);
        }
        if (lowerBounds.length == 0) {
            return null;
        }
        throw new AssertionError((Object)("Wildcard should have at most one lower bound: " + type));
    }

    static Class<?> getRawType(Type type) {
        return TypeToken.getRawTypes(type).iterator().next();
    }

    static Set<Class<?>> getRawTypes(Type type) {
        final HashSet set = new HashSet();
        new TypeVisitor(){

            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                this.visit(t.getBounds());
            }

            @Override
            void visitWildcardType(WildcardType t) {
                this.visit(t.getUpperBounds());
            }

            @Override
            void visitParameterizedType(ParameterizedType t) {
                set.add((Class)t.getRawType());
            }

            @Override
            void visitClass(Class<?> t) {
                set.add(t);
            }

            @Override
            void visitGenericArrayType(GenericArrayType t) {
                set.add(Types.getArrayClass(TypeToken.getRawType(t.getGenericComponentType())));
            }
        }.visit(type);
        return set;
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        private static final long serialVersionUID = 0L;

        SimpleTypeToken(Type type) {
            super(type);
        }
    }
}

