/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jfaster.mango.reflect.TypeToken;
import org.jfaster.mango.reflect.TypeVisitor;

public class TypeWrapper {
    private Class<?> mappedClass;
    private Type mappedType;
    private boolean isArray;
    private boolean isCollection;
    private boolean isList;
    private boolean isArrayList;
    private boolean isLinkedList;
    private boolean isSet;
    private boolean isHashSet;
    private boolean isCollectionAssignable;

    public TypeWrapper(final Type type) {
        if (byte[].class.equals((Object)type)) {
            this.mappedClass = byte[].class;
            this.mappedType = byte[].class;
        } else {
            new TypeVisitor(){

                @Override
                void visitClass(Class<?> t) {
                    TypeWrapper.this.mappedType = t;
                    if (t.isArray()) {
                        TypeWrapper.this.isArray = true;
                        TypeWrapper.this.mappedType = t.getComponentType();
                    }
                }

                @Override
                void visitGenericArrayType(GenericArrayType t) {
                    TypeWrapper.this.isArray = true;
                    TypeWrapper.this.mappedType = t.getGenericComponentType();
                }

                @Override
                void visitParameterizedType(ParameterizedType t) {
                    Type rawType = t.getRawType();
                    if (Collection.class.equals((Object)rawType)) {
                        TypeWrapper.this.isCollection = true;
                    } else if (List.class.equals((Object)rawType)) {
                        TypeWrapper.this.isList = true;
                    } else if (ArrayList.class.equals((Object)rawType)) {
                        TypeWrapper.this.isArrayList = true;
                    } else if (LinkedList.class.equals((Object)rawType)) {
                        TypeWrapper.this.isLinkedList = true;
                    } else if (Set.class.equals((Object)rawType)) {
                        TypeWrapper.this.isSet = true;
                    } else if (HashSet.class.equals((Object)rawType)) {
                        TypeWrapper.this.isHashSet = true;
                    } else {
                        throw new IllegalStateException("parameterized type must be one of[Collection,List,ArrayList,LinkedList,Set,HashSet] but " + type);
                    }
                    TypeWrapper.this.isCollectionAssignable = true;
                    TypeWrapper.this.mappedType = t.getActualTypeArguments()[0];
                }

                @Override
                void visitTypeVariable(TypeVariable<?> t) {
                    throw new IllegalStateException("Does not support the type " + type);
                }

                @Override
                void visitWildcardType(WildcardType t) {
                    throw new IllegalStateException("Does not support the type " + type);
                }
            }.visit(type);
            this.mappedClass = TypeToken.of(this.mappedType).getRawType();
        }
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isArrayList() {
        return this.isArrayList;
    }

    public boolean isLinkedList() {
        return this.isLinkedList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isHashSet() {
        return this.isHashSet;
    }

    public boolean isIterable() {
        return this.isCollectionAssignable || this.isArray;
    }

    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    public Type getMappedType() {
        return this.mappedType;
    }
}

