/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.transaction;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceUtils;
import org.jfaster.mango.exception.transaction.CannotCreateTransactionException;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.transaction.ConnectionHolder;
import org.jfaster.mango.transaction.Transaction;
import org.jfaster.mango.transaction.TransactionImpl;
import org.jfaster.mango.transaction.TransactionIsolationLevel;
import org.jfaster.mango.transaction.TransactionSynchronizationManager;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public abstract class TransactionFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TransactionFactory.class);

    public static Transaction newTransaction(Mango mango, String dataSourceName, TransactionIsolationLevel level) {
        DataSource dataSource = mango.getMasterDataSource(dataSourceName);
        if (dataSource == null) {
            throw new IllegalArgumentException("Can't find master DataSource from mango [" + mango + "] " + "with DataSourceName [" + dataSourceName + "]");
        }
        return TransactionFactory.newTransaction(dataSource, level);
    }

    public static Transaction newTransaction(Mango mango, String dataSourceName) {
        return TransactionFactory.newTransaction(mango, dataSourceName, TransactionIsolationLevel.DEFAULT);
    }

    public static Transaction newTransaction(String dataSourceName, TransactionIsolationLevel level) {
        List<Mango> mangos = Mango.getInstances();
        if (mangos.size() != 1) {
            throw new IllegalStateException("The number of instances mango expected 1 but " + mangos.size() + ", " + "Please specify mango instance");
        }
        return TransactionFactory.newTransaction(mangos.get(0), dataSourceName, level);
    }

    public static Transaction newTransaction(String dataSourceName) {
        return TransactionFactory.newTransaction(dataSourceName, TransactionIsolationLevel.DEFAULT);
    }

    public static Transaction newTransaction(TransactionIsolationLevel level) {
        return TransactionFactory.newTransaction("", level);
    }

    public static Transaction newTransaction() {
        return TransactionFactory.newTransaction("", TransactionIsolationLevel.DEFAULT);
    }

    private static Transaction newTransaction(DataSource dataSource, TransactionIsolationLevel level) {
        ConnectionHolder connHolder;
        if (dataSource == null) {
            new IllegalArgumentException("DataSource can't be null");
        }
        if (level == null) {
            new IllegalArgumentException("TransactionIsolationLevel can't be null");
        }
        return (connHolder = TransactionSynchronizationManager.getConnectionHolder(dataSource)) != null ? TransactionFactory.usingExistingTransaction(dataSource) : TransactionFactory.createNewTransaction(dataSource, level);
    }

    private static Transaction usingExistingTransaction(DataSource dataSource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Using existing transaction");
        }
        TransactionImpl transaction = new TransactionImpl(false, dataSource);
        return transaction;
    }

    private static Transaction createNewTransaction(DataSource dataSource, TransactionIsolationLevel expectedLevel) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new transaction");
        }
        Connection conn = null;
        try {
            Integer previousLevel = null;
            boolean isMustRestoreAutoCommit = false;
            conn = dataSource.getConnection();
            if (logger.isDebugEnabled()) {
                logger.debug("Acquired Connection [" + conn + "] for JDBC transaction");
            }
            if (expectedLevel != TransactionIsolationLevel.DEFAULT && (previousLevel = Integer.valueOf(conn.getTransactionIsolation())).intValue() != expectedLevel.getLevel()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Changing isolation level of JDBC Connection [" + conn + "] to " + expectedLevel.getLevel());
                }
                conn.setTransactionIsolation(expectedLevel.getLevel());
            }
            if (conn.getAutoCommit()) {
                isMustRestoreAutoCommit = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Switching JDBC Connection [" + conn + "] to manual commit");
                }
                conn.setAutoCommit(false);
            }
            TransactionImpl transaction = new TransactionImpl(true, dataSource, previousLevel, isMustRestoreAutoCommit);
            ConnectionHolder connHolder = new ConnectionHolder(conn);
            TransactionSynchronizationManager.bindConnectionHolder(dataSource, connHolder);
            return transaction;
        }
        catch (Throwable e) {
            DataSourceUtils.releaseConnection(conn, dataSource);
            throw new CannotCreateTransactionException("Could not open JDBC Connection for transaction", e);
        }
    }
}

