/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.transaction;

import org.jfaster.mango.exception.transaction.TransactionException;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.transaction.Transaction;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionFactory;
import org.jfaster.mango.transaction.TransactionIsolationLevel;
import org.jfaster.mango.transaction.TransactionStatus;

public class TransactionTemplate {
    public static void execute(Mango mango, String dataSourceName, TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(mango, dataSourceName, level), action);
    }

    public static void execute(Mango mango, String dataSourceName, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(mango, dataSourceName), action);
    }

    public static void execute(String dataSourceName, TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(dataSourceName, level), action);
    }

    public static void execute(String dataSourceName, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(dataSourceName), action);
    }

    public static void execute(TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(level), action);
    }

    public static void execute(TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(), action);
    }

    private static void execute(Transaction transaction, TransactionAction action) throws TransactionException {
        TransactionStatus status = new TransactionStatus();
        try {
            action.doInTransaction(status);
        }
        catch (RuntimeException e) {
            transaction.rollback();
            throw e;
        }
        if (status.isRollbackOnly()) {
            transaction.setRollbackOnly(true);
        }
        transaction.commit();
    }
}

