/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;

public class ToStringHelper {
    public static String toString(Method m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getDeclaringClass().getSimpleName()).append(".").append(m.getName()).append("(");
        ToStringHelper.printTypes(sb, m.getGenericParameterTypes(), "", ", ", "");
        return sb.append(")").toString();
    }

    public static String toString(Iterable<Class> clazzs) {
        ArrayList<String> ss = new ArrayList<String>();
        for (Class clazz : clazzs) {
            ss.add(clazz.getSimpleName());
        }
        return ((Object)ss).toString();
    }

    public static void printTypes(StringBuffer sb, Type[] types, String pre, String sep, String suf) {
        if (types.length > 0) {
            sb.append(pre);
        }
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            ToStringHelper.printType(sb, types[i]);
        }
        if (types.length > 0) {
            sb.append(suf);
        }
    }

    private static void printType(StringBuffer sb, Type type) {
        if (type instanceof Class) {
            Class t = (Class)type;
            sb.append(t.getSimpleName());
        } else if (type instanceof TypeVariable) {
            TypeVariable t = (TypeVariable)type;
            sb.append(t.getName());
            ToStringHelper.printTypes(sb, t.getBounds(), " extends ", " & ", "");
        } else if (type instanceof WildcardType) {
            WildcardType t = (WildcardType)type;
            sb.append("?");
            ToStringHelper.printTypes(sb, t.getLowerBounds(), " extends ", " & ", "");
            ToStringHelper.printTypes(sb, t.getUpperBounds(), " super ", " & ", "");
        } else if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            Type owner = t.getOwnerType();
            if (owner != null) {
                ToStringHelper.printType(sb, owner);
                sb.append(".");
            }
            ToStringHelper.printType(sb, t.getRawType());
            ToStringHelper.printTypes(sb, t.getActualTypeArguments(), "<", ", ", ">");
        } else if (type instanceof GenericArrayType) {
            GenericArrayType t = (GenericArrayType)type;
            sb.append("");
            ToStringHelper.printType(sb, t.getGenericComponentType());
            sb.append("[]");
        }
    }
}

