/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Chart3D;
import org.jfree.chart3d.Chart3DChangeEvent;
import org.jfree.chart3d.Chart3DChangeListener;
import org.jfree.chart3d.data.ItemKey;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.swing.Panel3D;
import org.jfree.chart3d.interaction.Chart3DMouseEvent;
import org.jfree.chart3d.interaction.Chart3DMouseListener;
import org.jfree.chart3d.internal.Args;

public class Chart3DPanel
extends Panel3D
implements Chart3DChangeListener,
ComponentListener {
    private final Chart3D chart;
    private final boolean autoFitOnPanelResize;
    private transient EventListenerList chartMouseListeners = new EventListenerList();

    public Chart3DPanel(Chart3D chart) {
        super(chart);
        this.chart = chart;
        this.chart.addChangeListener(this);
        this.addComponentListener(this);
        this.autoFitOnPanelResize = false;
        this.registerForTooltips();
    }

    public Chart3D getChart() {
        return this.chart;
    }

    @Override
    public void chartChanged(Chart3DChangeEvent event) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.autoFitOnPanelResize) {
            this.zoomToFit();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        ItemKey key;
        RenderingInfo info = this.getRenderingInfo();
        if (info == null) {
            return null;
        }
        Object3D object = info.fetchObjectAt(e.getX(), e.getY());
        if (object != null && (key = (ItemKey)object.getProperty("key")) != null) {
            return this.chart.getPlot().generateToolTipText(key);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        EventListener[] listeners = this.chartMouseListeners.getListeners(Chart3DMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        RenderedElement element = null;
        RenderingInfo info = this.getRenderingInfo();
        if (info != null) {
            element = info.findElementAt(e.getX(), e.getY());
        }
        Chart3DMouseEvent chartEvent = new Chart3DMouseEvent(this.chart, e, element);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((Chart3DMouseListener)listeners[i]).chartMouseClicked(chartEvent);
        }
        super.mouseClicked(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        EventListener[] listeners = this.chartMouseListeners.getListeners(Chart3DMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        RenderedElement element = null;
        RenderingInfo info = this.getRenderingInfo();
        if (info != null) {
            element = info.findElementAt(e.getX(), e.getY());
        }
        Chart3DMouseEvent chartEvent = new Chart3DMouseEvent(this.chart, e, element);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((Chart3DMouseListener)listeners[i]).chartMouseMoved(chartEvent);
        }
        super.mouseMoved(e);
    }

    public void addChartMouseListener(Chart3DMouseListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.chartMouseListeners.add(Chart3DMouseListener.class, listener);
    }

    public void removeChartMouseListener(Chart3DMouseListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.chartMouseListeners.remove(Chart3DMouseListener.class, listener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == Chart3DMouseListener.class) {
            return this.chartMouseListeners.getListeners(listenerType);
        }
        return super.getListeners(listenerType);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.chartMouseListeners = new EventListenerList();
        if (this.chart != null) {
            this.chart.addChangeListener(this);
        }
    }
}

