/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import org.jfree.chart3d.axis.TickSelector;
import org.jfree.chart3d.internal.Args;

public class IntegerTickSelector
implements TickSelector,
Serializable {
    private int power = 0;
    private int factor = 1;
    private final DecimalFormat df0 = new DecimalFormat("#,##0");

    @Override
    public double select(double reference) {
        Args.finitePositiveRequired(reference, "reference");
        this.power = (int)Math.ceil(Math.log10(reference));
        this.factor = 1;
        return this.getCurrentTickSize();
    }

    @Override
    public boolean next() {
        if (this.factor == 1) {
            this.factor = 2;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 5;
            return true;
        }
        if (this.factor == 5) {
            ++this.power;
            this.factor = 1;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    @Override
    public boolean previous() {
        if (this.factor == 1) {
            if (this.power == 0) {
                return false;
            }
            this.factor = 5;
            --this.power;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 1;
            return true;
        }
        if (this.factor == 5) {
            this.factor = 2;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    @Override
    public double getCurrentTickSize() {
        return (double)this.factor * Math.pow(10.0, this.power);
    }

    @Override
    public Format getCurrentTickLabelFormat() {
        if (this.power >= 0 && this.power <= 6) {
            return this.df0;
        }
        return new DecimalFormat("0.0000E0");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof IntegerTickSelector;
    }
}

