/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import org.jfree.chart3d.axis.TickSelector;
import org.jfree.chart3d.internal.Args;

public class NumberTickSelector
implements TickSelector,
Serializable {
    private int power = 0;
    private int factor = 1;
    private boolean percentage;
    private final DecimalFormat dfNeg4 = new DecimalFormat("0.0000");
    private final DecimalFormat dfNeg3 = new DecimalFormat("0.000");
    private final DecimalFormat dfNeg2 = new DecimalFormat("0.00");
    private final DecimalFormat dfNeg1 = new DecimalFormat("0.0");
    private final DecimalFormat df0 = new DecimalFormat("#,##0");
    private final DecimalFormat dfNeg4P = new DecimalFormat("0.00%");
    private final DecimalFormat dfNeg3P = new DecimalFormat("0.0%");
    private final DecimalFormat dfNeg2P = new DecimalFormat("0%");
    private final DecimalFormat dfNeg1P = new DecimalFormat("0%");
    private final DecimalFormat df0P = new DecimalFormat("#,##0%");

    public NumberTickSelector() {
        this(false);
    }

    public NumberTickSelector(boolean percentage) {
        this.percentage = percentage;
    }

    @Override
    public double select(double reference) {
        Args.finitePositiveRequired(reference, "reference");
        this.power = (int)Math.ceil(Math.log10(reference));
        this.factor = 1;
        return this.getCurrentTickSize();
    }

    @Override
    public boolean next() {
        if (this.factor == 1) {
            this.factor = 2;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 5;
            return true;
        }
        if (this.factor == 5) {
            ++this.power;
            this.factor = 1;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    @Override
    public boolean previous() {
        if (this.factor == 1) {
            this.factor = 5;
            --this.power;
            return true;
        }
        if (this.factor == 2) {
            this.factor = 1;
            return true;
        }
        if (this.factor == 5) {
            this.factor = 2;
            return true;
        }
        throw new IllegalStateException("We should never get here.");
    }

    @Override
    public double getCurrentTickSize() {
        return (double)this.factor * Math.pow(10.0, this.power);
    }

    @Override
    public Format getCurrentTickLabelFormat() {
        if (this.power == -4) {
            return this.percentage ? this.dfNeg4P : this.dfNeg4;
        }
        if (this.power == -3) {
            return this.percentage ? this.dfNeg3P : this.dfNeg3;
        }
        if (this.power == -2) {
            return this.percentage ? this.dfNeg2P : this.dfNeg2;
        }
        if (this.power == -1) {
            return this.percentage ? this.dfNeg1P : this.dfNeg1;
        }
        if (this.power >= 0 && this.power <= 6) {
            return this.percentage ? this.df0P : this.df0;
        }
        return this.percentage ? new DecimalFormat("0.0000E0%") : new DecimalFormat("0.0000E0");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberTickSelector)) {
            return false;
        }
        NumberTickSelector that = (NumberTickSelector)obj;
        return this.percentage == that.percentage;
    }
}

