/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.util.List;
import org.jfree.chart3d.data.KeyedValues3D;
import org.jfree.chart3d.data.KeyedValues3DItemKey;
import org.jfree.chart3d.data.NullConversion;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.Values;
import org.jfree.chart3d.data.Values3D;
import org.jfree.chart3d.data.xyz.XYZDataset;
import org.jfree.chart3d.data.xyz.XYZSeries;
import org.jfree.chart3d.data.xyz.XYZSeriesCollection;
import org.jfree.chart3d.internal.Args;

public class DataUtils {
    private DataUtils() {
    }

    public static double total(Values<Number> values) {
        double result = 0.0;
        for (int i = 0; i < values.getItemCount(); ++i) {
            Number n = values.getValue(i);
            if (n == null) continue;
            result += n.doubleValue();
        }
        return result;
    }

    public static <S extends Comparable<S>> int count(KeyedValues3D<S, ?, ?, ?> data, S seriesKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex((int)seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        int count = 0;
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(seriesIndex, r, c);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static <R extends Comparable<R>> int countForRow(KeyedValues3D<?, R, ?, ?> data, R rowKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(rowKey, "rowKey");
        int rowIndex = data.getRowIndex((int)rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        int count = 0;
        int seriesCount = data.getSeriesCount();
        int columnCount = data.getColumnCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = (Number)data.getValue(s, rowIndex, c);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static <C extends Comparable<C>> int countForColumn(KeyedValues3D<?, ?, C, ?> data, C columnKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(columnKey, "columnKey");
        int columnIndex = data.getColumnIndex((int)columnKey);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column not found: " + columnKey);
        }
        int count = 0;
        int seriesCount = data.getSeriesCount();
        int rowCount = data.getRowCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int r = 0; r < rowCount; ++r) {
                Number n = (Number)data.getValue(s, r, columnIndex);
                if (n == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static <S extends Comparable<S>> double total(KeyedValues3D<S, ?, ?, ? extends Number> data, S seriesKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex((int)seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        double total = 0.0;
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = data.getValue(seriesIndex, r, c);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static <R extends Comparable<R>> double totalForRow(KeyedValues3D<?, R, ?, ? extends Number> data, R rowKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(rowKey, "rowKey");
        int rowIndex = data.getRowIndex((int)rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        double total = 0.0;
        int seriesCount = data.getSeriesCount();
        int columnCount = data.getColumnCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int c = 0; c < columnCount; ++c) {
                Number n = data.getValue(s, rowIndex, c);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static <C extends Comparable<C>> double totalForColumn(KeyedValues3D<?, ?, C, ? extends Number> data, C columnKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(columnKey, "columnKey");
        int columnIndex = data.getColumnIndex((int)columnKey);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column not found: " + columnKey);
        }
        double total = 0.0;
        int seriesCount = data.getSeriesCount();
        int rowCount = data.getRowCount();
        for (int s = 0; s < seriesCount; ++s) {
            for (int r = 0; r < rowCount; ++r) {
                Number n = data.getValue(s, r, columnIndex);
                if (n == null) continue;
                total += n.doubleValue();
            }
        }
        return total;
    }

    public static Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findValueRange(data, Double.NaN);
    }

    public static Range findValueRange(Values3D<? extends Number> data, double base) {
        return DataUtils.findValueRange(data, base, true);
    }

    public static Range findValueRange(Values3D<? extends Number> data, double base, boolean finite) {
        Args.nullNotPermitted(data, "data");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int series = 0; series < data.getSeriesCount(); ++series) {
            for (int row = 0; row < data.getRowCount(); ++row) {
                for (int col = 0; col < data.getColumnCount(); ++col) {
                    double d = data.getDoubleValue(series, row, col);
                    if (Double.isNaN(d) || finite && Double.isInfinite(d)) continue;
                    min = Math.min(min, d);
                    max = Math.max(max, d);
                }
            }
        }
        if (!Double.isNaN(base)) {
            min = Math.min(min, base);
            max = Math.max(max, base);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findStackedValueRange(Values3D<? extends Number> data) {
        return DataUtils.findStackedValueRange(data, 0.0);
    }

    public static Range findStackedValueRange(Values3D<? extends Number> data, double base) {
        Args.nullNotPermitted(data, "data");
        double min = base;
        double max = base;
        int seriesCount = data.getSeriesCount();
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int col = 0; col < data.getColumnCount(); ++col) {
                double[] total = DataUtils.stackSubTotal(data, base, seriesCount, row, col);
                min = Math.min(min, total[0]);
                max = Math.max(max, total[1]);
            }
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static double[] stackSubTotal(Values3D<? extends Number> data, double base, int series, int row, int column) {
        double neg = base;
        double pos = base;
        for (int s = 0; s < series; ++s) {
            double v = data.getDoubleValue(s, row, column);
            if (v > 0.0) {
                pos += v;
                continue;
            }
            if (!(v < 0.0)) continue;
            neg += v;
        }
        return new double[]{neg, pos};
    }

    public static <S extends Comparable<S>> double total(XYZDataset<S> data, S seriesKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        double total = 0.0;
        int itemCount = data.getItemCount(seriesIndex);
        for (int item = 0; item < itemCount; ++item) {
            double y = data.getY(seriesIndex, item);
            if (Double.isNaN(y)) continue;
            total += y;
        }
        return total;
    }

    public static Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset, Double.NaN);
    }

    public static Range findXRange(XYZDataset dataset, double inc) {
        return DataUtils.findXRange(dataset, inc, true);
    }

    public static Range findXRange(XYZDataset dataset, double inc, boolean finite) {
        Args.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double x = dataset.getX(s, i);
                if (Double.isNaN(x) || finite && Double.isInfinite(x)) continue;
                min = Math.min(x, min);
                max = Math.max(x, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset, Double.NaN);
    }

    public static Range findYRange(XYZDataset dataset, double inc) {
        return DataUtils.findYRange(dataset, inc, true);
    }

    public static Range findYRange(XYZDataset dataset, double inc, boolean finite) {
        Args.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double y = dataset.getY(s, i);
                if (Double.isNaN(y) || finite && Double.isInfinite(y)) continue;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset, Double.NaN);
    }

    public static Range findZRange(XYZDataset dataset, double inc) {
        return DataUtils.findZRange(dataset, inc, true);
    }

    public static Range findZRange(XYZDataset dataset, double inc, boolean finite) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.finiteRequired(inc, "inc");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double z = dataset.getZ(s, i);
                if (Double.isNaN(z) || finite && Double.isInfinite(z)) continue;
                min = Math.min(z, min);
                max = Math.max(z, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>> XYZDataset extractXYZDatasetFromRows(KeyedValues3D<S, R, C, ? extends Number> source, R xRowKey, R yRowKey, R zRowKey) {
        return DataUtils.extractXYZDatasetFromRows(source, xRowKey, yRowKey, zRowKey, NullConversion.SKIP, null);
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>> XYZDataset extractXYZDatasetFromRows(KeyedValues3D<S, R, C, ? extends Number> source, R xRowKey, R yRowKey, R zRowKey, NullConversion nullConversion, List<KeyedValues3DItemKey> exceptions) {
        Args.nullNotPermitted(source, "source");
        Args.nullNotPermitted(xRowKey, "xRowKey");
        Args.nullNotPermitted(yRowKey, "yRowKey");
        Args.nullNotPermitted(zRowKey, "zRowKey");
        XYZSeriesCollection<Comparable> dataset = new XYZSeriesCollection<Comparable>();
        for (Comparable seriesKey : source.getSeriesKeys()) {
            XYZSeries<Comparable> series = new XYZSeries<Comparable>(seriesKey);
            for (Comparable colKey : source.getColumnKeys()) {
                R rrKey;
                Number x = source.getValue(seriesKey, xRowKey, colKey);
                Number y = source.getValue(seriesKey, yRowKey, colKey);
                Number z = source.getValue(seriesKey, zRowKey, colKey);
                if (x != null && y != null && z != null) {
                    series.add(x.doubleValue(), y.doubleValue(), z.doubleValue());
                    continue;
                }
                if (exceptions != null) {
                    rrKey = zRowKey;
                    if (x == null) {
                        rrKey = xRowKey;
                    } else if (y == null) {
                        rrKey = yRowKey;
                    }
                    exceptions.add(new KeyedValues3DItemKey<Comparable, R, Comparable>(seriesKey, rrKey, colKey));
                }
                if (nullConversion.equals((Object)NullConversion.THROW_EXCEPTION)) {
                    rrKey = zRowKey;
                    if (x == null) {
                        rrKey = yRowKey;
                    } else if (y == null) {
                        rrKey = yRowKey;
                    }
                    throw new RuntimeException("There is a null value for the item [" + seriesKey + ", " + rrKey + ", " + colKey + "].");
                }
                if (nullConversion == NullConversion.SKIP) continue;
                double xx = DataUtils.convert(x, nullConversion);
                double yy = DataUtils.convert(y, nullConversion);
                double zz = DataUtils.convert(z, nullConversion);
                series.add(xx, yy, zz);
            }
            dataset.add(series);
        }
        return dataset;
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>> XYZDataset<S> extractXYZDatasetFromColumns(KeyedValues3D<S, R, C, ? extends Number> source, C xColKey, C yColKey, C zColKey) {
        return DataUtils.extractXYZDatasetFromColumns(source, xColKey, yColKey, zColKey, NullConversion.SKIP, null);
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>> XYZDataset<S> extractXYZDatasetFromColumns(KeyedValues3D<S, R, C, ? extends Number> source, C xColKey, C yColKey, C zColKey, NullConversion nullConversion, List<KeyedValues3DItemKey> exceptions) {
        Args.nullNotPermitted(source, "source");
        Args.nullNotPermitted(xColKey, "xColKey");
        Args.nullNotPermitted(yColKey, "yColKey");
        Args.nullNotPermitted(zColKey, "zColKey");
        XYZSeriesCollection<Comparable> dataset = new XYZSeriesCollection<Comparable>();
        for (Comparable seriesKey : source.getSeriesKeys()) {
            XYZSeries<Comparable> series = new XYZSeries<Comparable>(seriesKey);
            for (Comparable rowKey : source.getRowKeys()) {
                C ccKey;
                Number x = source.getValue(seriesKey, rowKey, xColKey);
                Number y = source.getValue(seriesKey, rowKey, yColKey);
                Number z = source.getValue(seriesKey, rowKey, zColKey);
                if (x != null && y != null && z != null) {
                    series.add(x.doubleValue(), y.doubleValue(), z.doubleValue());
                    continue;
                }
                if (exceptions != null) {
                    ccKey = zColKey;
                    if (x == null) {
                        ccKey = xColKey;
                    } else if (y == null) {
                        ccKey = yColKey;
                    }
                    exceptions.add(new KeyedValues3DItemKey<Comparable, Comparable, C>(seriesKey, rowKey, ccKey));
                }
                if (nullConversion.equals((Object)NullConversion.THROW_EXCEPTION)) {
                    ccKey = zColKey;
                    if (x == null) {
                        ccKey = xColKey;
                    } else if (y == null) {
                        ccKey = yColKey;
                    }
                    throw new RuntimeException("There is a null value for the item [" + seriesKey + ", " + rowKey + ", " + ccKey + "].");
                }
                if (nullConversion == NullConversion.SKIP) continue;
                double xx = DataUtils.convert(x, nullConversion);
                double yy = DataUtils.convert(y, nullConversion);
                double zz = DataUtils.convert(z, nullConversion);
                series.add(xx, yy, zz);
            }
            dataset.add(series);
        }
        return dataset;
    }

    private static double convert(Number n, NullConversion nullConversion) {
        if (n != null) {
            return n.doubleValue();
        }
        if (nullConversion.equals((Object)NullConversion.CONVERT_TO_ZERO)) {
            return 0.0;
        }
        return Double.NaN;
    }
}

