/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.io.Serializable;
import org.jfree.chart3d.data.KeyedValue;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;

public final class DefaultKeyedValue<K extends Comparable<K>, T>
implements KeyedValue<K, T>,
Serializable {
    private final K key;
    private T value;

    public DefaultKeyedValue(K key, T value) {
        Args.nullNotPermitted(key, "key");
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValue)) {
            return false;
        }
        DefaultKeyedValue that = (DefaultKeyedValue)obj;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return ObjectUtils.equals(this.value, that.value);
    }

    public String toString() {
        return "(" + this.key.toString() + ", " + this.value + ")";
    }
}

