/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.data.DefaultKeyedValues2D;
import org.jfree.chart3d.data.KeyedValues;
import org.jfree.chart3d.data.KeyedValues2D;
import org.jfree.chart3d.data.KeyedValues3D;
import org.jfree.chart3d.data.StandardPieDataset3D;
import org.jfree.chart3d.data.category.StandardCategoryDataset3D;
import org.jfree.chart3d.data.xyz.XYZDataset;
import org.jfree.chart3d.data.xyz.XYZSeries;
import org.jfree.chart3d.data.xyz.XYZSeriesCollection;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.util.json.JSONValue;
import org.jfree.chart3d.util.json.parser.ContainerFactory;
import org.jfree.chart3d.util.json.parser.JSONParser;
import org.jfree.chart3d.util.json.parser.ParseException;

public class JSONUtils {
    public static KeyedValues<String, Number> readKeyedValues(String json) {
        KeyedValues<String, Number> result;
        Args.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues<String, Number> readKeyedValues(Reader reader) throws IOException {
        Args.nullNotPermitted(reader, "reader");
        try {
            JSONParser parser = new JSONParser();
            List list = (List)parser.parse(reader, JSONUtils.createContainerFactory());
            StandardPieDataset3D<String> result = new StandardPieDataset3D<String>();
            for (Object item : list) {
                List itemAsList = (List)item;
                result.add(itemAsList.get(0).toString(), (Number)itemAsList.get(1));
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String writeKeyedValues(KeyedValues data) {
        Args.nullNotPermitted(data, "data");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues(data, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues(KeyedValues data, Writer writer) throws IOException {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(writer, "writer");
        writer.write("[");
        boolean first = true;
        for (Object key : data.getKeys()) {
            if (!first) {
                writer.write(", ");
            } else {
                first = false;
            }
            writer.write("[");
            writer.write(JSONValue.toJSONString(key.toString()));
            writer.write(", ");
            writer.write(JSONValue.toJSONString(data.getValue((Comparable)key)));
            writer.write("]");
        }
        writer.write("]");
    }

    public static KeyedValues2D<String, String, Number> readKeyedValues2D(String json) {
        KeyedValues2D<String, String, Number> result;
        Args.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues2D(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues2D<String, String, Number> readKeyedValues2D(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Map map = (Map)parser.parse(reader, JSONUtils.createContainerFactory());
            DefaultKeyedValues2D<String, String, Number> result = new DefaultKeyedValues2D<String, String, Number>();
            if (map.isEmpty()) {
                return result;
            }
            Object keysObj = map.get("columnKeys");
            List keys = null;
            if (!(keysObj instanceof List)) {
                if (keysObj == null) {
                    throw new RuntimeException("No 'columnKeys' defined.");
                }
                throw new RuntimeException("Please check the 'columnKeys', the format does not parse to a list.");
            }
            keys = (List)keysObj;
            Object dataObj = map.get("rows");
            if (dataObj instanceof List) {
                List rowList = (List)dataObj;
                for (Object rowObj : rowList) {
                    JSONUtils.processRow(rowObj, keys, result);
                }
            } else {
                if (dataObj == null) {
                    throw new RuntimeException("No 'rows' section defined.");
                }
                throw new RuntimeException("Please check the 'rows' entry, the format does not parse to a list of rows.");
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    static void processRow(Object rowObj, List<String> columnKeys, DefaultKeyedValues2D dataset) {
        if (!(rowObj instanceof List)) {
            throw new RuntimeException("Check the 'data' section it contains a row that does not parse to a list.");
        }
        List rowList = (List)rowObj;
        Object rowKey = rowList.get(0);
        Object rowDataObj = rowList.get(1);
        if (!(rowDataObj instanceof List)) {
            throw new RuntimeException("Please check the row entry for " + rowKey + " because it is not parsing to a list (of rowKey and rowDataValues items.");
        }
        List rowData = (List)rowDataObj;
        if (rowData.size() != columnKeys.size()) {
            throw new RuntimeException("The values list for series " + rowKey + " does not contain the correct number of entries to match the columnKeys.");
        }
        for (int c = 0; c < rowData.size(); ++c) {
            String columnKey = columnKeys.get(c);
            dataset.setValue(JSONUtils.objToDouble(rowData.get(c)), rowKey.toString(), columnKey.toString());
        }
    }

    public static String writeKeyedValues2D(KeyedValues2D data) {
        Args.nullNotPermitted(data, "data");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues2D(data, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues2D(KeyedValues2D data, Writer writer) throws IOException {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(writer, "writer");
        List columnKeys = data.getColumnKeys();
        List rowKeys = data.getRowKeys();
        writer.write("{");
        if (!columnKeys.isEmpty()) {
            writer.write("\"columnKeys\": [");
            boolean first = true;
            for (Comparable columnKey : columnKeys) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(columnKey.toString()));
            }
            writer.write("]");
        }
        if (!rowKeys.isEmpty()) {
            writer.write(", \"rows\": [");
            boolean firstRow = true;
            for (Comparable rowKey : rowKeys) {
                if (!firstRow) {
                    writer.write(", [");
                } else {
                    writer.write("[");
                    firstRow = false;
                }
                writer.write(JSONValue.toJSONString(rowKey.toString()));
                writer.write(", [");
                boolean first = true;
                for (Comparable columnKey : columnKeys) {
                    if (!first) {
                        writer.write(", ");
                    } else {
                        first = false;
                    }
                    writer.write(JSONValue.toJSONString(data.getValue(rowKey, columnKey)));
                }
                writer.write("]]");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    public static KeyedValues3D<String, String, String, Number> readKeyedValues3D(String json) {
        KeyedValues3D<String, String, String, Number> result;
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readKeyedValues3D(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static KeyedValues3D<String, String, String, Number> readKeyedValues3D(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Map map = (Map)parser.parse(reader, JSONUtils.createContainerFactory());
            StandardCategoryDataset3D<String, String, String> result = new StandardCategoryDataset3D<String, String, String>();
            if (map.isEmpty()) {
                return result;
            }
            Object rowKeysObj = map.get("rowKeys");
            if (!(rowKeysObj instanceof List)) {
                if (rowKeysObj == null) {
                    throw new RuntimeException("No 'rowKeys' defined.");
                }
                throw new RuntimeException("Please check the 'rowKeys', the format does not parse to a list.");
            }
            List rowKeys = (List)rowKeysObj;
            Object columnKeysObj = map.get("columnKeys");
            if (!(columnKeysObj instanceof List)) {
                if (columnKeysObj == null) {
                    throw new RuntimeException("No 'columnKeys' defined.");
                }
                throw new RuntimeException("Please check the 'columnKeys', the format does not parse to a list.");
            }
            List columnKeys = (List)columnKeysObj;
            Object dataObj = map.get("data");
            if (dataObj instanceof List) {
                List seriesList = (List)dataObj;
                for (Object seriesObj : seriesList) {
                    JSONUtils.processSeries(seriesObj, rowKeys, columnKeys, result);
                }
            } else {
                if (dataObj == null) {
                    throw new RuntimeException("No 'data' section defined.");
                }
                throw new RuntimeException("Please check the 'data' entry, the format does not parse to a list of series.");
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    static <R extends Comparable<R>, C extends Comparable<C>> void processSeries(Object seriesObj, List<R> rowKeys, List<C> columnKeys, StandardCategoryDataset3D<String, String, String> dataset) {
        if (!(seriesObj instanceof Map)) {
            throw new RuntimeException("Check the 'data' section it contains a series that does not parse to a map.");
        }
        Map seriesMap = (Map)seriesObj;
        Object seriesKey = seriesMap.get("seriesKey");
        Object seriesRowsObj = seriesMap.get("rows");
        if (!(seriesRowsObj instanceof Map)) {
            throw new RuntimeException("Please check the series entry for " + seriesKey + " because it is not parsing to a map (of rowKey -> rowDataValues items.");
        }
        Map seriesData = (Map)seriesRowsObj;
        for (Object rowKey : seriesData.keySet()) {
            if (!rowKeys.contains(rowKey)) {
                throw new RuntimeException("The row key " + rowKey + " is not listed in the rowKeys entry.");
            }
            Object rowValuesObj = seriesData.get(rowKey);
            if (!(rowValuesObj instanceof List)) {
                throw new RuntimeException("Please check the entry for series " + seriesKey + " and row " + rowKey + " because it does not parse to a list of values.");
            }
            List rowValues = (List)rowValuesObj;
            if (rowValues.size() != columnKeys.size()) {
                throw new RuntimeException("The values list for series " + seriesKey + " and row " + rowKey + " does not contain the correct number of entries to match the columnKeys.");
            }
            for (int c = 0; c < rowValues.size(); ++c) {
                C columnKey = columnKeys.get(c);
                dataset.addValue(JSONUtils.objToDouble(rowValues.get(c)), seriesKey.toString(), rowKey.toString(), columnKey.toString());
            }
        }
    }

    public static String writeKeyedValues3D(KeyedValues3D dataset) {
        Args.nullNotPermitted(dataset, "dataset");
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeKeyedValues3D(dataset, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeKeyedValues3D(KeyedValues3D dataset, Writer writer) throws IOException {
        boolean first;
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(writer, "writer");
        writer.write("{");
        if (!dataset.getColumnKeys().isEmpty()) {
            writer.write("\"columnKeys\": [");
            first = true;
            for (Object key : dataset.getColumnKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(key.toString()));
            }
            writer.write("], ");
        }
        if (!dataset.getRowKeys().isEmpty()) {
            writer.write("\"rowKeys\": [");
            first = true;
            for (Object key : dataset.getRowKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write(JSONValue.toJSONString(key.toString()));
            }
            writer.write("], ");
        }
        if (dataset.getSeriesCount() != 0) {
            writer.write("\"series\": [");
            first = true;
            for (Object seriesKey : dataset.getSeriesKeys()) {
                if (!first) {
                    writer.write(", ");
                } else {
                    first = false;
                }
                writer.write("{\"seriesKey\": ");
                writer.write(JSONValue.toJSONString(seriesKey.toString()));
                writer.write(", \"rows\": [");
                boolean firstRow = true;
                for (Object rowKey : dataset.getRowKeys()) {
                    if (JSONUtils.countForRowInSeries(dataset, (Comparable)seriesKey, (Comparable)rowKey) <= 0) continue;
                    if (!firstRow) {
                        writer.write(", [");
                    } else {
                        writer.write("[");
                        firstRow = false;
                    }
                    writer.write(JSONValue.toJSONString(rowKey.toString()) + ", [");
                    for (int c = 0; c < dataset.getColumnCount(); ++c) {
                        Object columnKey = dataset.getColumnKey(c);
                        if (c != 0) {
                            writer.write(", ");
                        }
                        writer.write(JSONValue.toJSONString(dataset.getValue((Comparable)seriesKey, (Comparable)rowKey, (Comparable)columnKey)));
                    }
                    writer.write("]]");
                }
                writer.write("]}");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    private static int countForRowInSeries(KeyedValues3D data, Comparable seriesKey, Comparable rowKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        Args.nullNotPermitted(rowKey, "rowKey");
        int seriesIndex = data.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series not found: " + seriesKey);
        }
        int rowIndex = data.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row not found: " + rowKey);
        }
        int count = 0;
        for (int c = 0; c < data.getColumnCount(); ++c) {
            Object n = data.getValue(seriesIndex, rowIndex, c);
            if (n == null) continue;
            ++count;
        }
        return count;
    }

    public static XYZDataset<String> readXYZDataset(String json) {
        XYZDataset<String> result;
        Args.nullNotPermitted(json, "json");
        StringReader in = new StringReader(json);
        try {
            result = JSONUtils.readXYZDataset(in);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public static XYZDataset<String> readXYZDataset(Reader reader) throws IOException {
        JSONParser parser = new JSONParser();
        XYZSeriesCollection<String> result = new XYZSeriesCollection<String>();
        try {
            List list = (List)parser.parse(reader, JSONUtils.createContainerFactory());
            for (Object seriesArray : list) {
                if (seriesArray instanceof List) {
                    List seriesList = (List)seriesArray;
                    XYZSeries series = JSONUtils.createSeries(seriesList);
                    result.add(series);
                    continue;
                }
                throw new RuntimeException("Input for a series did not parse to a list.");
            }
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static String writeXYZDataset(XYZDataset dataset) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writeXYZDataset(dataset, sw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static void writeXYZDataset(XYZDataset dataset, Writer writer) throws IOException {
        writer.write("[");
        boolean first = true;
        for (Object seriesKey : dataset.getSeriesKeys()) {
            if (!first) {
                writer.write(", [");
            } else {
                writer.write("[");
                first = false;
            }
            writer.write(JSONValue.toJSONString(seriesKey.toString()));
            writer.write(", [");
            int seriesIndex = dataset.getSeriesIndex((Comparable)seriesKey);
            int itemCount = dataset.getItemCount(seriesIndex);
            for (int i = 0; i < itemCount; ++i) {
                if (i != 0) {
                    writer.write(", ");
                }
                writer.write("[");
                writer.write(JSONValue.toJSONString(dataset.getX(seriesIndex, i)));
                writer.write(", ");
                writer.write(JSONValue.toJSONString(dataset.getY(seriesIndex, i)));
                writer.write(", ");
                writer.write(JSONValue.toJSONString(dataset.getZ(seriesIndex, i)));
                writer.write("]");
            }
            writer.write("]]");
        }
        writer.write("]");
    }

    private static double objToDouble(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        double result = Double.NaN;
        try {
            result = Double.parseDouble(obj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static XYZSeries createSeries(List<?> sArray) {
        Comparable key = (Comparable)sArray.get(0);
        List dataItems = (List)sArray.get(1);
        XYZSeries<Comparable> series = new XYZSeries<Comparable>(key);
        for (Object item : dataItems) {
            if (item instanceof List) {
                List xyz = (List)item;
                if (xyz.size() != 3) {
                    throw new RuntimeException("A data item should contain three numbers, but we have " + xyz);
                }
                double x = JSONUtils.objToDouble(xyz.get(0));
                double y = JSONUtils.objToDouble(xyz.get(1));
                double z = JSONUtils.objToDouble(xyz.get(2));
                series.add(x, y, z);
                continue;
            }
            throw new RuntimeException("Expecting a data item (x, y, z) for series " + key + " but found " + item + ".");
        }
        return series;
    }

    private static ContainerFactory createContainerFactory() {
        return new ContainerFactory(){

            @Override
            public Map createObjectContainer() {
                return new LinkedHashMap();
            }

            @Override
            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
    }
}

