/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.util.ArrayList;
import java.util.Collection;
import org.jfree.chart3d.data.KeyedValues3D;
import org.jfree.chart3d.data.KeyedValues3DItemKey;
import org.jfree.chart3d.internal.Args;

public class KeyedValues3DItemKeys {
    private KeyedValues3DItemKeys() {
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>, T> Collection<KeyedValues3DItemKey> itemKeysForSeries(KeyedValues3D<S, R, C, T> data, S seriesKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getSeriesKeys().contains(seriesKey)) {
            return result;
        }
        for (Comparable rowKey : data.getRowKeys()) {
            for (Comparable columnKey : data.getColumnKeys()) {
                KeyedValues3DItemKey<S, Comparable, Comparable> key = new KeyedValues3DItemKey<S, Comparable, Comparable>(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>, T> Collection<KeyedValues3DItemKey> itemKeysForRow(KeyedValues3D<S, R, C, T> data, R rowKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(rowKey, "rowKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getRowKeys().contains(rowKey)) {
            return result;
        }
        for (Comparable seriesKey : data.getSeriesKeys()) {
            for (Comparable columnKey : data.getColumnKeys()) {
                KeyedValues3DItemKey<Comparable, R, Comparable> key = new KeyedValues3DItemKey<Comparable, R, Comparable>(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }

    public static <S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>, T> Collection<KeyedValues3DItemKey> itemKeysForColumn(KeyedValues3D<S, R, C, T> data, C columnKey) {
        Args.nullNotPermitted(data, "data");
        Args.nullNotPermitted(columnKey, "columnKey");
        ArrayList<KeyedValues3DItemKey> result = new ArrayList<KeyedValues3DItemKey>();
        if (!data.getColumnKeys().contains(columnKey)) {
            return result;
        }
        for (Comparable seriesKey : data.getSeriesKeys()) {
            for (Comparable rowKey : data.getRowKeys()) {
                KeyedValues3DItemKey<Comparable, Comparable, C> key = new KeyedValues3DItemKey<Comparable, Comparable, C>(seriesKey, rowKey, columnKey);
                result.add(key);
            }
        }
        return result;
    }
}

