/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data.category;

import java.io.Serializable;
import java.util.List;
import org.jfree.chart3d.data.AbstractDataset3D;
import org.jfree.chart3d.data.DefaultKeyedValues3D;
import org.jfree.chart3d.data.JSONUtils;
import org.jfree.chart3d.data.KeyedValues;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.internal.Args;

public final class StandardCategoryDataset3D<S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>>
extends AbstractDataset3D
implements CategoryDataset3D<S, R, C>,
Serializable {
    private final DefaultKeyedValues3D<S, R, C, Number> data = new DefaultKeyedValues3D();

    @Override
    public int getSeriesCount() {
        return this.data.getSeriesCount();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    public S getSeriesKey(int seriesIndex) {
        return this.data.getSeriesKey(seriesIndex);
    }

    @Override
    public R getRowKey(int rowIndex) {
        return this.data.getRowKey(rowIndex);
    }

    @Override
    public C getColumnKey(int columnIndex) {
        return this.data.getColumnKey(columnIndex);
    }

    @Override
    public int getSeriesIndex(S serieskey) {
        return this.data.getSeriesIndex(serieskey);
    }

    @Override
    public int getRowIndex(R rowkey) {
        return this.data.getRowIndex(rowkey);
    }

    @Override
    public int getColumnIndex(C columnkey) {
        return this.data.getColumnIndex(columnkey);
    }

    @Override
    public List<S> getSeriesKeys() {
        return this.data.getSeriesKeys();
    }

    @Override
    public List<R> getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public List<C> getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public Number getValue(S seriesKey, R rowKey, C columnKey) {
        return this.data.getValue(seriesKey, rowKey, columnKey);
    }

    @Override
    public Number getValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.getValue(seriesIndex, rowIndex, columnIndex);
    }

    public void setValue(Number n, S seriesKey, R rowKey, C columnKey) {
        this.data.setValue(n, seriesKey, rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void addValue(Number n, S seriesKey, R rowKey, C columnKey) {
        this.setValue(n, seriesKey, rowKey, columnKey);
    }

    @Override
    public double getDoubleValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.getDoubleValue(seriesIndex, rowIndex, columnIndex);
    }

    public void addSeriesAsRow(S seriesKey, KeyedValues<C, ? extends Number> data) {
        this.addSeriesAsRow(seriesKey, seriesKey, data);
    }

    public void addSeriesAsRow(S seriesKey, R rowKey, KeyedValues<C, ? extends Number> data) {
        Args.nullNotPermitted(seriesKey, "seriesKey");
        Args.nullNotPermitted(data, "data");
        for (Comparable key : data.getKeys()) {
            this.setValue(data.getValue(key), seriesKey, rowKey, key);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryDataset3D)) {
            return false;
        }
        StandardCategoryDataset3D that = (StandardCategoryDataset3D)obj;
        return this.data.equals(that.data);
    }

    public String toString() {
        return JSONUtils.writeKeyedValues3D(this);
    }
}

