/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data.function;

import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.function.Function3D;
import org.jfree.chart3d.internal.Args;

public class Function3DUtils {
    private Function3DUtils() {
    }

    public static Range findYRange(Function3D f, Range xRange, Range zRange, int xSamples, int zSamples, boolean ignoreNaN) {
        Args.nullNotPermitted(f, "f");
        Args.nullNotPermitted(xRange, "xRange");
        Args.nullNotPermitted(zRange, "zRange");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int xIndex = 0; xIndex <= xSamples - 1; ++xIndex) {
            double fracX = (double)xIndex / ((double)xSamples - 1.0);
            double x = xRange.value(fracX);
            for (int zIndex = 0; zIndex <= zSamples - 1; ++zIndex) {
                double fracZ = (double)zIndex / ((double)zSamples - 1.0);
                double z = zRange.value(fracZ);
                double y = f.getValue(x, z);
                if (Double.isNaN(y) && ignoreNaN) continue;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }
}

