/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics2d;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.graphics2d.RefPt2D;
import org.jfree.chart3d.graphics2d.Scale2D;
import org.jfree.chart3d.internal.Args;

public class Fit2D
implements Serializable {
    public static final Fit2D CENTER_NO_SCALING = new Fit2D(Anchor2D.CENTER, Scale2D.NONE);
    public static final Fit2D TOP_LEFT_NO_SCALING = new Fit2D(Anchor2D.TOP_LEFT, Scale2D.NONE);
    public static final Fit2D TOP_CENTER_NO_SCALING = new Fit2D(Anchor2D.TOP_CENTER, Scale2D.NONE);
    public static final Fit2D TOP_RIGHT_NO_SCALING = new Fit2D(Anchor2D.TOP_RIGHT, Scale2D.NONE);
    public static final Fit2D CENTER_LEFT_NO_SCALING = new Fit2D(Anchor2D.CENTER_LEFT, Scale2D.NONE);
    public static final Fit2D CENTER_RIGHT_NO_SCALING = new Fit2D(Anchor2D.CENTER_RIGHT, Scale2D.NONE);
    public static final Fit2D BOTTOM_LEFT_NO_SCALING = new Fit2D(Anchor2D.BOTTOM_LEFT, Scale2D.NONE);
    public static final Fit2D BOTTOM_CENTER_NO_SCALING = new Fit2D(Anchor2D.BOTTOM_CENTER, Scale2D.NONE);
    public static final Fit2D BOTTOM_RIGHT_NO_SCALING = new Fit2D(Anchor2D.BOTTOM_RIGHT, Scale2D.NONE);
    public static final Fit2D SCALE_TO_FIT_TARGET = new Fit2D(Anchor2D.CENTER, Scale2D.SCALE_BOTH);
    private final Anchor2D anchor;
    private final Scale2D scale;

    public static Fit2D getNoScalingFitter(RefPt2D refPt) {
        switch (refPt) {
            case TOP_LEFT: {
                return TOP_LEFT_NO_SCALING;
            }
            case TOP_CENTER: {
                return TOP_CENTER_NO_SCALING;
            }
            case TOP_RIGHT: {
                return TOP_RIGHT_NO_SCALING;
            }
            case CENTER_LEFT: {
                return CENTER_LEFT_NO_SCALING;
            }
            case CENTER: {
                return CENTER_NO_SCALING;
            }
            case CENTER_RIGHT: {
                return CENTER_RIGHT_NO_SCALING;
            }
            case BOTTOM_LEFT: {
                return BOTTOM_LEFT_NO_SCALING;
            }
            case BOTTOM_CENTER: {
                return BOTTOM_CENTER_NO_SCALING;
            }
            case BOTTOM_RIGHT: {
                return BOTTOM_RIGHT_NO_SCALING;
            }
        }
        throw new IllegalStateException("RefPt2D not recognised : " + refPt);
    }

    public Fit2D(Anchor2D anchor, Scale2D scale) {
        Args.nullNotPermitted(anchor, "anchor");
        Args.nullNotPermitted((Object)scale, "scale");
        this.anchor = anchor;
        this.scale = scale;
    }

    public Anchor2D getAnchor() {
        return this.anchor;
    }

    public Scale2D getScale() {
        return this.scale;
    }

    public Rectangle2D fit(Dimension2D srcDim, Rectangle2D target) {
        Rectangle2D.Double result = new Rectangle2D.Double();
        if (this.scale == Scale2D.SCALE_BOTH) {
            result.setFrame(target);
            return result;
        }
        double width = srcDim.getWidth();
        if (this.scale == Scale2D.SCALE_HORIZONTAL) {
            width = target.getWidth();
            if (!this.anchor.getRefPt().isHorizontalCenter()) {
                width -= 2.0 * this.anchor.getOffset().getDX();
            }
        }
        double height = srcDim.getHeight();
        if (this.scale == Scale2D.SCALE_VERTICAL) {
            height = target.getHeight();
            if (!this.anchor.getRefPt().isVerticalCenter()) {
                height -= 2.0 * this.anchor.getOffset().getDY();
            }
        }
        Point2D pt = this.anchor.getAnchorPoint(target);
        double x = Double.NaN;
        if (this.anchor.getRefPt().isLeft()) {
            x = pt.getX();
        } else if (this.anchor.getRefPt().isHorizontalCenter()) {
            x = target.getCenterX() - width / 2.0;
        } else if (this.anchor.getRefPt().isRight()) {
            x = pt.getX() - width;
        }
        double y = Double.NaN;
        if (this.anchor.getRefPt().isTop()) {
            y = pt.getY();
        } else if (this.anchor.getRefPt().isVerticalCenter()) {
            y = target.getCenterY() - height / 2.0;
        } else if (this.anchor.getRefPt().isBottom()) {
            y = pt.getY() - height;
        }
        ((Rectangle2D)result).setRect(x, y, width, height);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fit2D)) {
            return false;
        }
        Fit2D that = (Fit2D)obj;
        if (!this.anchor.equals(that.anchor)) {
            return false;
        }
        return this.scale.equals((Object)that.scale);
    }
}

