/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart3d.graphics3d.Face;
import org.jfree.chart3d.graphics3d.LabelFace;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.RenderedElement;

public class RenderingInfo {
    private final List<Face> faces;
    Point2D[] projPts;
    private final double dx;
    public double dy;
    List<RenderedElement> otherElements;
    List<RenderedElement> otherOffsetElements;

    public RenderingInfo(List<Face> faces, Point2D[] projPts, double dx, double dy) {
        this.faces = faces;
        this.projPts = projPts;
        this.dx = dx;
        this.dy = dy;
        this.otherElements = new ArrayList<RenderedElement>();
        this.otherOffsetElements = new ArrayList<RenderedElement>();
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public Point2D[] getProjectedPoints() {
        return this.projPts;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public void addElement(RenderedElement element) {
        this.otherElements.add(element);
    }

    public void addOffsetElement(RenderedElement element) {
        this.otherOffsetElements.add(element);
    }

    public Object3D fetchObjectAt(double x, double y) {
        for (int i = this.faces.size() - 1; i >= 0; --i) {
            Path2D p;
            Rectangle2D bounds;
            Face f = this.faces.get(i);
            if (!(f instanceof LabelFace ? (bounds = (Rectangle2D)f.getOwner().getProperty("labelBounds")) != null && bounds.contains(x - this.dx, y - this.dy) : (p = f.createPath(this.projPts)).contains(x - this.dx, y - this.dy))) continue;
            return f.getOwner();
        }
        return null;
    }

    public RenderedElement findElementAt(double x, double y) {
        Shape bounds;
        RenderedElement element;
        int i;
        for (i = this.otherElements.size() - 1; i >= 0; --i) {
            element = this.otherElements.get(i);
            bounds = (Shape)element.getProperty("bounds");
            if (!bounds.contains(x, y)) continue;
            return element;
        }
        for (i = this.otherOffsetElements.size() - 1; i >= 0; --i) {
            element = this.otherOffsetElements.get(i);
            bounds = (Shape)element.getProperty("bounds");
            if (bounds == null || !bounds.contains(x - this.dx, y - this.dy)) continue;
            return element;
        }
        Object3D obj = this.fetchObjectAt(x, y);
        if (obj != null) {
            element = new RenderedElement("obj3d", null);
            element.setProperty("key", obj.getProperty("key"));
            if (obj.getProperty("class") != null) {
                element.setProperty("class", obj.getProperty("class"));
            }
            return element;
        }
        return null;
    }
}

