/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart3d.graphics3d.Face;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.graphics3d.internal.Utils3D;
import org.jfree.chart3d.internal.Args;

public class World {
    public static final String DEFAULT_PARTITION_KEY = "default";
    private double sunX;
    private double sunY;
    private double sunZ;
    private Map<String, List<Object3D>> objects = new TreeMap<String, List<Object3D>>();

    public World() {
        this.objects.put(DEFAULT_PARTITION_KEY, new ArrayList());
        this.setSunSource(new Point3D(2.0, -1.0, 10.0));
    }

    public double getSunX() {
        return this.sunX;
    }

    public double getSunY() {
        return this.sunY;
    }

    public double getSunZ() {
        return this.sunZ;
    }

    public final void setSunSource(double x, double y, double z) {
        this.setSunSource(new Point3D(x, y, z));
    }

    public final void setSunSource(Point3D p) {
        Args.nullNotPermitted(p, "p");
        Point3D normal = Utils3D.normalise(p);
        this.sunX = normal.getX();
        this.sunY = normal.getY();
        this.sunZ = normal.getZ();
    }

    public void add(Object3D object) {
        this.add(DEFAULT_PARTITION_KEY, object);
    }

    public void add(String partition, Object3D object) {
        Args.nullNotPermitted(partition, "partition");
        Args.nullNotPermitted(object, "object");
        List<Object3D> list = this.objects.get(partition);
        if (list == null) {
            list = new ArrayList<Object3D>();
            this.objects.put(partition, list);
        }
        list.add(object);
    }

    public void addAll(Collection<Object3D> objects) {
        Args.nullNotPermitted(objects, "objects");
        for (Object3D object : objects) {
            this.add(object);
        }
    }

    public void clear(String partitionKey) {
        Args.nullNotPermitted(partitionKey, "partitionKey");
        this.objects.put(partitionKey, null);
    }

    public int getVertexCount() {
        int count = 0;
        for (Map.Entry<String, List<Object3D>> entry : this.objects.entrySet()) {
            List<Object3D> objs = entry.getValue();
            for (Object3D object : objs) {
                count += object.getVertexCount();
            }
        }
        return count;
    }

    public Point3D[] calculateEyeCoordinates(ViewPoint3D vp) {
        Point3D[] result = new Point3D[this.getVertexCount()];
        int index = 0;
        for (Map.Entry<String, List<Object3D>> entry : this.objects.entrySet()) {
            List<Object3D> objs = entry.getValue();
            for (Object3D object : objs) {
                Point3D[] vertices = object.calculateEyeCoordinates(vp);
                System.arraycopy(vertices, 0, result, index, vertices.length);
                index += vertices.length;
            }
        }
        return result;
    }

    public Point2D[] calculateProjectedPoints(ViewPoint3D vp, double d) {
        Point2D[] result = new Point2D[this.getVertexCount()];
        int index = 0;
        for (Map.Entry<String, List<Object3D>> entry : this.objects.entrySet()) {
            List<Object3D> objs = entry.getValue();
            for (Object3D object : objs) {
                Point2D[] pts = object.calculateProjectedPoints(vp, d);
                System.arraycopy(pts, 0, result, index, pts.length);
                index += pts.length;
            }
        }
        return result;
    }

    public List<Face> getFaces() {
        ArrayList<Face> result = new ArrayList<Face>();
        int offset = 0;
        for (Map.Entry<String, List<Object3D>> entry : this.objects.entrySet()) {
            List<Object3D> objs = entry.getValue();
            for (Object3D object : objs) {
                for (Face f : object.getFaces()) {
                    f.setOffset(offset);
                }
                offset += object.getVertexCount();
                result.addAll(object.getFaces());
            }
        }
        return result;
    }

    public List<Object3D> getObjects() {
        ArrayList<Object3D> result = new ArrayList<Object3D>();
        for (Map.Entry<String, List<Object3D>> entry : this.objects.entrySet()) {
            List<Object3D> objs = entry.getValue();
            result.addAll(objs);
        }
        return result;
    }
}

