/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart3d.Resources;
import org.jfree.chart3d.graphics3d.swing.Panel3D;
import org.jfree.chart3d.internal.Args;

public class ExportToPDFAction
extends AbstractAction {
    private final Panel3D panel;

    public ExportToPDFAction(Panel3D panel) {
        super(Resources.localString("PDF_MENU_LABEL"));
        Args.nullNotPermitted(panel, "Name");
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Resources.localString("PDF_FILE_FILTER_DESCRIPTION"), "pdf");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showSaveDialog(this.panel);
        if (option == 0) {
            Object filename = fileChooser.getSelectedFile().getPath();
            if (!((String)filename).endsWith(".pdf")) {
                filename = (String)filename + ".pdf";
            }
            this.panel.writeAsPDF(new File((String)filename), this.panel.getWidth(), this.panel.getHeight());
        }
    }
}

