/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.jfree.chart3d.export.ExportUtils;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.Drawable3D;
import org.jfree.chart3d.graphics3d.Offset2D;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.internal.Args;

public class Panel3D
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final Drawable3D drawable;
    private final double minViewingDistance;
    private double maxViewingDistanceMultiplier;
    private double margin;
    private double panIncrement;
    private double rotateIncrement;
    private double rollIncrement;
    private Point lastClickPoint;
    private Point lastMovePoint;
    private Offset2D offsetAtMousePressed;
    private RenderingInfo renderingInfo;

    public Panel3D(Drawable3D drawable) {
        super(new BorderLayout());
        Args.nullNotPermitted(drawable, "drawable");
        this.drawable = drawable;
        this.margin = 0.25;
        this.minViewingDistance = drawable.getDimensions().getDiagonalLength();
        this.maxViewingDistanceMultiplier = 8.0;
        this.panIncrement = 0.05235987755982988;
        this.rotateIncrement = 0.05235987755982988;
        this.rollIncrement = 0.05235987755982988;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public Drawable3D getDrawable() {
        return this.drawable;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public double getMinViewingDistance() {
        return this.minViewingDistance;
    }

    public double getMaxViewingDistanceMultiplier() {
        return this.maxViewingDistanceMultiplier;
    }

    public void setMaxViewingDistanceMultiplier(double multiplier) {
        this.maxViewingDistanceMultiplier = multiplier;
    }

    public double getPanIncrement() {
        return this.panIncrement;
    }

    public void setPanIncrement(double panIncrement) {
        this.panIncrement = panIncrement;
    }

    public double getRotateIncrement() {
        return this.rotateIncrement;
    }

    public void setRotateIncrement(double rotateIncrement) {
        this.rotateIncrement = rotateIncrement;
    }

    public double getRollIncrement() {
        return this.rollIncrement;
    }

    public void setRollIncrement(double rollIncrement) {
        this.rollIncrement = rollIncrement;
    }

    public ViewPoint3D getViewPoint() {
        return this.drawable.getViewPoint();
    }

    public void setViewPoint(ViewPoint3D vp) {
        Args.nullNotPermitted(vp, "vp");
        this.drawable.setViewPoint(vp);
        this.repaint();
    }

    protected Point getLastClickPoint() {
        return this.lastClickPoint;
    }

    protected RenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    public void panLeftRight(double angle) {
        this.drawable.getViewPoint().panLeftRight(angle);
        this.repaint();
    }

    public void zoomToFit() {
        this.zoomToFit(this.getSize());
    }

    public void zoomToFit(Dimension2D size) {
        int w = (int)(size.getWidth() * (1.0 - this.margin));
        int h = (int)(size.getHeight() * (1.0 - this.margin));
        Dimension target = new Dimension(w, h);
        Dimension3D d3d = this.drawable.getDimensions();
        float distance = this.drawable.getViewPoint().optimalDistance(target, d3d, this.drawable.getProjDistance());
        this.drawable.getViewPoint().setRho(distance);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform saved = g2.getTransform();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle drawArea = new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        this.renderingInfo = this.drawable.draw(g2, drawArea);
        g2.setTransform(saved);
    }

    public void registerForTooltips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void unregisterForTooltips() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMovePoint = this.lastClickPoint = e.getPoint();
        this.offsetAtMousePressed = this.drawable.getTranslate2D();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isAltDown()) {
            Point currPt = e.getPoint();
            Offset2D offset = this.offsetAtMousePressed;
            Point lastPt = this.getLastClickPoint();
            double dx = offset.getDX() + (double)(currPt.x - lastPt.x);
            double dy = offset.getDY() + (double)(currPt.y - lastPt.y);
            this.drawable.setTranslate2D(new Offset2D(dx, dy));
        } else {
            Point currPt = e.getPoint();
            int dx = currPt.x - this.lastMovePoint.x;
            int dy = currPt.y - this.lastMovePoint.y;
            this.lastMovePoint = currPt;
            this.drawable.getViewPoint().panLeftRight((double)(-dx) * Math.PI / 120.0);
            this.drawable.getViewPoint().moveUpDown((double)(-dy) * Math.PI / 120.0);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        float units = mwe.getUnitsToScroll();
        double maxViewingDistance = this.maxViewingDistanceMultiplier * this.minViewingDistance;
        double valRho = Math.max(this.minViewingDistance, Math.min(maxViewingDistance, this.drawable.getViewPoint().getRho() + (double)units));
        this.drawable.getViewPoint().setRho(valRho);
        this.repaint();
    }

    void writeAsPDF(File file, int w, int h) {
        ExportUtils.writeAsPDF(this.drawable, w, h, file);
    }

    void writeAsSVG(File file, int w, int h) {
        ExportUtils.writeAsSVG(this.drawable, w, h, file);
    }
}

