/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.label;

import java.io.Serializable;
import java.util.Formatter;
import org.jfree.chart3d.data.KeyedValues3DItemKey;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.interaction.KeyedValues3DItemSelection;
import org.jfree.chart3d.interaction.StandardKeyedValues3DItemSelection;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.label.CategoryItemLabelGenerator;

public class StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
Serializable {
    public static final String VALUE_TEMPLATE = "%4$.2f";
    public static final String KEYS_AND_VALUE_TEMPLATE = "%s, %s, %s = %4$.3f";
    public static final String SERIES_AND_COLUMN_KEYS_AND_VALUE_TEMPLATE = "%1$s, %3$s = %4$.3f";
    public static final String DEFAULT_TEMPLATE = "%1$s, %3$s = %4$.3f";
    private String template;
    private KeyedValues3DItemSelection itemSelection;

    public StandardCategoryItemLabelGenerator() {
        this("%1$s, %3$s = %4$.3f");
    }

    public StandardCategoryItemLabelGenerator(String template) {
        Args.nullNotPermitted(template, "template");
        this.template = template;
        this.itemSelection = null;
    }

    public KeyedValues3DItemSelection getItemSelection() {
        return this.itemSelection;
    }

    public void setItemSelection(StandardKeyedValues3DItemSelection selection) {
        this.itemSelection = selection;
    }

    @Override
    public String generateItemLabel(CategoryDataset3D dataset, Comparable<?> seriesKey, Comparable<?> rowKey, Comparable<?> columnKey) {
        KeyedValues3DItemKey key;
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        Args.nullNotPermitted(rowKey, "rowKey");
        Args.nullNotPermitted(columnKey, "columnKey");
        if (this.itemSelection != null && !this.itemSelection.isSelected(key = new KeyedValues3DItemKey(seriesKey, rowKey, columnKey))) {
            return null;
        }
        Formatter formatter = new Formatter(new StringBuilder());
        Number value = (Number)dataset.getValue(seriesKey, rowKey, columnKey);
        Double d = null;
        if (value != null) {
            d = value.doubleValue();
        }
        formatter.format(this.template, seriesKey, rowKey, columnKey, d);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryItemLabelGenerator)) {
            return false;
        }
        StandardCategoryItemLabelGenerator that = (StandardCategoryItemLabelGenerator)obj;
        if (!this.template.equals(that.template)) {
            return false;
        }
        return ObjectUtils.equals(this.itemSelection, that.itemSelection);
    }

    public int hashCode() {
        return this.template.hashCode();
    }
}

