/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.label;

import java.io.Serializable;
import java.util.Formatter;
import org.jfree.chart3d.data.DataUtils;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.label.CategoryLabelGenerator;

public class StandardCategoryLabelGenerator<S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>>
implements CategoryLabelGenerator<S, R, C>,
Serializable {
    public static final String KEY_ONLY_TEMPLATE = "%s";
    public static final String TOTAL_TEMPLATE = "%s (%3$,.0f)";
    public static final String TOTAL_TEMPLATE_2DP = "%s (%3$,.2f)";
    public static final String DEFAULT_TEMPLATE = "%s";
    private String template;

    public StandardCategoryLabelGenerator() {
        this("%s");
    }

    public StandardCategoryLabelGenerator(String template) {
        Args.nullNotPermitted(template, "template");
        this.template = template;
    }

    @Override
    public String generateSeriesLabel(CategoryDataset3D<S, R, C> dataset, S seriesKey) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(seriesKey, "seriesKey");
        Formatter formatter = new Formatter(new StringBuilder());
        int count = DataUtils.count(dataset, seriesKey);
        double total = DataUtils.total(dataset, seriesKey);
        formatter.format(this.template, seriesKey, count, total);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    @Override
    public String generateRowLabel(CategoryDataset3D<S, R, C> dataset, R rowKey) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(rowKey, "rowKey");
        Formatter formatter = new Formatter(new StringBuilder());
        int count = DataUtils.countForRow(dataset, rowKey);
        double total = DataUtils.totalForRow(dataset, rowKey);
        formatter.format(this.template, rowKey, count, total);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    @Override
    public String generateColumnLabel(CategoryDataset3D<S, R, C> dataset, C columnKey) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(columnKey, "columnKey");
        Formatter formatter = new Formatter(new StringBuilder());
        int count = DataUtils.countForColumn(dataset, columnKey);
        double total = DataUtils.totalForColumn(dataset, columnKey);
        formatter.format(this.template, columnKey, count, total);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryLabelGenerator)) {
            return false;
        }
        StandardCategoryLabelGenerator that = (StandardCategoryLabelGenerator)obj;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }
}

