/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.legend;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart3d.Orientation;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.legend.LegendBuilder;
import org.jfree.chart3d.legend.LegendItemInfo;
import org.jfree.chart3d.plot.Plot3D;
import org.jfree.chart3d.style.ChartStyle;
import org.jfree.chart3d.table.AbstractTableElement;
import org.jfree.chart3d.table.FlowElement;
import org.jfree.chart3d.table.GridElement;
import org.jfree.chart3d.table.HAlign;
import org.jfree.chart3d.table.ShapeElement;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TextElement;
import org.jfree.chart3d.table.VAlign;
import org.jfree.chart3d.table.VerticalFlowElement;

public final class StandardLegendBuilder
implements LegendBuilder,
Serializable {
    private String header;
    private HAlign headerAlignment;
    private String footer;
    private HAlign footerAlignment;
    private HAlign rowAlignment;
    private VAlign columnAlignment;

    public StandardLegendBuilder() {
        this(null, null);
    }

    public StandardLegendBuilder(String header, String footer) {
        this.header = header;
        this.headerAlignment = HAlign.LEFT;
        this.footer = footer;
        this.footerAlignment = HAlign.RIGHT;
        this.rowAlignment = null;
        this.columnAlignment = null;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public HAlign getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderAlignment(HAlign align) {
        Args.nullNotPermitted((Object)align, "align");
        this.headerAlignment = align;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public HAlign getFooterAlignment() {
        return this.footerAlignment;
    }

    public void setFooterAlignment(HAlign align) {
        Args.nullNotPermitted((Object)align, "align");
        this.footerAlignment = align;
    }

    public HAlign getRowAlignment() {
        return this.rowAlignment;
    }

    public void setRowAlignment(HAlign alignment) {
        this.rowAlignment = alignment;
    }

    public VAlign getColumnAlignment() {
        return this.columnAlignment;
    }

    public void setColumnAlignment(VAlign alignment) {
        this.columnAlignment = alignment;
    }

    @Override
    public TableElement createLegend(Plot3D plot, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        TableElement legend = this.createSimpleLegend(plot.getLegendInfo(), anchor, orientation, style);
        if (this.header != null || this.footer != null) {
            GridElement<String, String> compositeLegend = new GridElement<String, String>();
            compositeLegend.setBackground(null);
            if (this.header != null) {
                TextElement he = new TextElement(this.header, style.getLegendHeaderFont());
                he.setHorizontalAligment(this.headerAlignment);
                he.setBackgroundColor(style.getLegendHeaderBackgroundColor());
                compositeLegend.setElement(he, "R0", "C1");
            }
            compositeLegend.setElement(legend, "R1", "C1");
            if (this.footer != null) {
                TextElement fe = new TextElement(this.footer, style.getLegendFooterFont());
                fe.setHorizontalAligment(this.footerAlignment);
                fe.setBackgroundColor(style.getLegendFooterBackgroundColor());
                compositeLegend.setElement(fe, "R2", "C1");
            }
            return compositeLegend;
        }
        return legend;
    }

    private TableElement createSimpleLegend(List<LegendItemInfo> items, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        AbstractTableElement legend;
        Args.nullNotPermitted(items, "items");
        Args.nullNotPermitted((Object)orientation, "orientation");
        if (orientation == Orientation.HORIZONTAL) {
            FlowElement fe = new FlowElement(this.horizontalAlignment(anchor), 2);
            fe.setRefPoint(anchor.getRefPt());
            legend = fe;
        } else {
            VerticalFlowElement vfe = new VerticalFlowElement(this.verticalAlignment(anchor), 2);
            vfe.setRefPoint(anchor.getRefPt());
            legend = vfe;
        }
        for (LegendItemInfo item : items) {
            Shape shape = item.getShape();
            if (shape == null) {
                shape = style.getLegendItemShape();
            }
            TableElement legendItem = this.createLegendItem(item.getLabel(), style.getLegendItemFont(), style.getLegendItemColor(), shape, item.getColor(), style.getLegendItemBackgroundColor());
            legendItem.setProperty("class", (Object)InteractiveElementType.LEGEND_ITEM);
            legendItem.setProperty("series_key", item.getSeriesKey());
            legend.addElement(legendItem);
        }
        return legend;
    }

    private HAlign horizontalAlignment(Anchor2D anchor) {
        if (this.rowAlignment != null) {
            return this.rowAlignment;
        }
        if (anchor.getRefPt().isLeft()) {
            return HAlign.LEFT;
        }
        if (anchor.getRefPt().isRight()) {
            return HAlign.RIGHT;
        }
        return HAlign.CENTER;
    }

    private VAlign verticalAlignment(Anchor2D anchor) {
        if (this.columnAlignment != null) {
            return this.columnAlignment;
        }
        if (anchor.getRefPt().isTop()) {
            return VAlign.TOP;
        }
        if (anchor.getRefPt().isBottom()) {
            return VAlign.BOTTOM;
        }
        return VAlign.MIDDLE;
    }

    private TableElement createLegendItem(String text, Font font, Color textColor, Shape shape, Color shapeColor, Color background) {
        ShapeElement se = new ShapeElement(shape, shapeColor);
        se.setBackgroundColor(background);
        TextElement te = new TextElement(text, font);
        te.setColor(textColor);
        te.setBackgroundColor(background);
        GridElement<String, String> ge = new GridElement<String, String>();
        ge.setElement(se, "R1", "C1");
        ge.setElement(te, "R1", "C2");
        return ge;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardLegendBuilder)) {
            return false;
        }
        StandardLegendBuilder that = (StandardLegendBuilder)obj;
        if (!ObjectUtils.equals(this.header, that.header)) {
            return false;
        }
        if (this.headerAlignment != that.headerAlignment) {
            return false;
        }
        if (!ObjectUtils.equals(this.footer, that.footer)) {
            return false;
        }
        return this.footerAlignment == that.footerAlignment;
    }
}

