/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.marker;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Chart3DChangeListener;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.graphics2d.RefPt2D;
import org.jfree.chart3d.graphics2d.TextAnchor;
import org.jfree.chart3d.graphics3d.internal.Utils2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.TextUtils;
import org.jfree.chart3d.marker.Marker;
import org.jfree.chart3d.marker.MarkerChangeEvent;
import org.jfree.chart3d.marker.MarkerChangeListener;

public abstract class AbstractMarker
implements Marker {
    private final transient EventListenerList listenerList = new EventListenerList();

    AbstractMarker() {
    }

    protected void drawMarkerLabel(Graphics2D g2, String label, double x, double y, Anchor2D anchor, Line2D refLine, boolean reverse) {
        double angle = Utils2D.calculateTheta(refLine);
        boolean vflip = false;
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
            vflip = true;
        }
        if (angle < -1.5707963267948966) {
            angle += Math.PI;
            vflip = true;
        }
        if (reverse) {
            vflip = !vflip;
        }
        double lineLength = Utils2D.length(refLine);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(label, g2);
        if (bounds.getWidth() < lineLength) {
            TextAnchor textAnchor = AbstractMarker.deriveTextAnchorForLine(anchor.getRefPt(), !vflip);
            TextUtils.drawRotatedString(label, g2, (float)x, (float)y, textAnchor, angle, textAnchor);
        }
    }

    protected void drawMarkerLabel(Graphics2D g2, String label, double x, double y, Anchor2D anchor, Line2D refLine1, Line2D refLine2, boolean reverse) {
        double angle = anchor.getRefPt().isTop() ? Utils2D.calculateTheta(refLine2) : (anchor.getRefPt().isBottom() ? Utils2D.calculateTheta(refLine1) : (Utils2D.calculateTheta(refLine1) + Utils2D.calculateTheta(refLine2)) / 2.0);
        boolean vflip = false;
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
            vflip = true;
        }
        if (angle < -1.5707963267948966) {
            angle += Math.PI;
            vflip = true;
        }
        if (reverse) {
            vflip = !vflip;
        }
        double lineLength1 = Utils2D.length(refLine1);
        double lineLength2 = Utils2D.length(refLine2);
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(label, g2);
        if (bounds.getWidth() < Math.min(lineLength1, lineLength2)) {
            TextAnchor textAnchor = AbstractMarker.deriveTextAnchor(anchor.getRefPt(), !vflip);
            TextUtils.drawRotatedString(label, g2, (float)x, (float)y, textAnchor, angle, textAnchor);
        }
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addChangeListener(MarkerChangeListener listener) {
        this.listenerList.add(MarkerChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(MarkerChangeListener listener) {
        this.listenerList.remove(MarkerChangeListener.class, listener);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Chart3DChangeListener.class) continue;
            ((MarkerChangeListener)listeners[i + 1]).markerChanged(new MarkerChangeEvent(this, this));
        }
    }

    protected static TextAnchor deriveTextAnchor(RefPt2D refPt, boolean vflip) {
        Args.nullNotPermitted((Object)refPt, "refPt");
        if (refPt.equals((Object)RefPt2D.TOP_LEFT)) {
            return vflip ? TextAnchor.TOP_LEFT : TextAnchor.BOTTOM_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.TOP_CENTER)) {
            return vflip ? TextAnchor.TOP_CENTER : TextAnchor.BOTTOM_CENTER;
        }
        if (refPt.equals((Object)RefPt2D.TOP_RIGHT)) {
            return vflip ? TextAnchor.TOP_RIGHT : TextAnchor.BOTTOM_LEFT;
        }
        if (refPt.equals((Object)RefPt2D.CENTER_LEFT)) {
            return vflip ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.CENTER)) {
            return TextAnchor.CENTER;
        }
        if (refPt.equals((Object)RefPt2D.CENTER_RIGHT)) {
            return vflip ? TextAnchor.CENTER_RIGHT : TextAnchor.CENTER_LEFT;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_LEFT)) {
            return vflip ? TextAnchor.BOTTOM_LEFT : TextAnchor.TOP_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_CENTER)) {
            return vflip ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_RIGHT)) {
            return vflip ? TextAnchor.BOTTOM_RIGHT : TextAnchor.TOP_LEFT;
        }
        throw new RuntimeException("Unknown refPt " + refPt);
    }

    protected static TextAnchor deriveTextAnchorForLine(RefPt2D refPt, boolean vflip) {
        if (refPt.equals((Object)RefPt2D.TOP_LEFT)) {
            return vflip ? TextAnchor.BOTTOM_LEFT : TextAnchor.TOP_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.TOP_CENTER)) {
            return vflip ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        }
        if (refPt.equals((Object)RefPt2D.TOP_RIGHT)) {
            return vflip ? TextAnchor.BOTTOM_RIGHT : TextAnchor.TOP_LEFT;
        }
        if (refPt.equals((Object)RefPt2D.CENTER_LEFT)) {
            return vflip ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.CENTER)) {
            return TextAnchor.CENTER;
        }
        if (refPt.equals((Object)RefPt2D.CENTER_RIGHT)) {
            return vflip ? TextAnchor.CENTER_RIGHT : TextAnchor.CENTER_LEFT;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_LEFT)) {
            return vflip ? TextAnchor.TOP_LEFT : TextAnchor.BOTTOM_RIGHT;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_CENTER)) {
            return vflip ? TextAnchor.TOP_CENTER : TextAnchor.BOTTOM_CENTER;
        }
        if (refPt.equals((Object)RefPt2D.BOTTOM_RIGHT)) {
            return vflip ? TextAnchor.TOP_RIGHT : TextAnchor.BOTTOM_LEFT;
        }
        throw new RuntimeException("Unknown refPt " + refPt);
    }
}

