/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.marker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.marker.AbstractMarker;
import org.jfree.chart3d.marker.CategoryMarkerType;
import org.jfree.chart3d.marker.Marker;
import org.jfree.chart3d.marker.MarkerData;
import org.jfree.chart3d.marker.MarkerDataType;
import org.jfree.chart3d.marker.MarkerLine;

public class CategoryMarker
extends AbstractMarker
implements Serializable {
    Comparable<?> category;
    CategoryMarkerType type;
    private String label;
    private Font font;
    private Color labelColor;
    private Anchor2D labelAnchor;
    private transient Stroke lineStroke;
    private Color lineColor;
    private Color fillColor;

    public CategoryMarker(Comparable<?> category) {
        Args.nullNotPermitted(category, "category");
        this.category = category;
        this.type = CategoryMarkerType.BAND;
        this.font = Marker.DEFAULT_MARKER_FONT;
        this.labelColor = Marker.DEFAULT_LABEL_COLOR;
        this.labelAnchor = Anchor2D.CENTER;
        this.lineStroke = DEFAULT_LINE_STROKE;
        this.lineColor = DEFAULT_LINE_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
    }

    public Comparable<?> getCategory() {
        return this.category;
    }

    public void setCategory(Comparable<?> category) {
        Args.nullNotPermitted(category, "category");
        this.category = category;
        this.fireChangeEvent();
    }

    public CategoryMarkerType getType() {
        return this.type;
    }

    public void setType(CategoryMarkerType type) {
        Args.nullNotPermitted((Object)type, "type");
        this.type = type;
        this.fireChangeEvent();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.font = font;
        this.fireChangeEvent();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.labelColor = color;
        this.fireChangeEvent();
    }

    public Anchor2D getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(Anchor2D anchor) {
        Args.nullNotPermitted(anchor, "anchor");
        this.labelAnchor = anchor;
        this.fireChangeEvent();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.lineColor = color;
        this.fireChangeEvent();
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.lineStroke = stroke;
        this.fireChangeEvent();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.fillColor = color;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D g2, MarkerData markerData, boolean reverse) {
        if (markerData.getType().equals((Object)MarkerDataType.VALUE)) {
            MarkerLine ml = markerData.getValueLine();
            g2.setPaint(this.lineColor);
            g2.setStroke(this.lineStroke);
            Line2D.Double l = new Line2D.Double(ml.getStartPoint(), ml.getEndPoint());
            g2.draw(l);
            Point2D labelPoint = markerData.getLabelPoint();
            if (labelPoint != null) {
                g2.setFont(this.font);
                g2.setColor(this.labelColor);
                this.drawMarkerLabel(g2, this.label, labelPoint.getX(), labelPoint.getY(), this.labelAnchor, l, reverse);
            }
        } else if (markerData.getType().equals((Object)MarkerDataType.RANGE)) {
            MarkerLine sl = markerData.getStartLine();
            Line2D.Double l1 = new Line2D.Double(sl.getStartPoint(), sl.getEndPoint());
            MarkerLine el = markerData.getEndLine();
            Line2D.Double l2 = new Line2D.Double(el.getStartPoint(), el.getEndPoint());
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(((Line2D)l1).getX1(), ((Line2D)l1).getY1());
            ((Path2D)path).lineTo(((Line2D)l1).getX2(), ((Line2D)l1).getY2());
            ((Path2D)path).lineTo(((Line2D)l2).getX2(), ((Line2D)l2).getY2());
            ((Path2D)path).lineTo(((Line2D)l2).getX1(), ((Line2D)l2).getY1());
            path.closePath();
            g2.setPaint(this.fillColor);
            g2.fill(path);
            g2.setColor(this.lineColor);
            g2.setStroke(this.lineStroke);
            g2.draw(l1);
            g2.draw(l2);
            Point2D labelPoint = markerData.getLabelPoint();
            if (labelPoint != null) {
                g2.setFont(this.font);
                g2.setColor(this.labelColor);
                this.drawMarkerLabel(g2, this.label, labelPoint.getX(), labelPoint.getY(), markerData.getLabelAnchor(), l1, l2, reverse);
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + ObjectUtils.hashCode(this.category);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryMarker other = (CategoryMarker)obj;
        if (!ObjectUtils.equals(this.category, other.category)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!ObjectUtils.equals(this.label, other.label)) {
            return false;
        }
        if (!ObjectUtils.equals(this.font, other.font)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelColor, other.labelColor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelAnchor, other.labelAnchor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.lineStroke, other.lineStroke)) {
            return false;
        }
        if (!ObjectUtils.equals(this.lineColor, other.lineColor)) {
            return false;
        }
        return ObjectUtils.equals(this.fillColor, other.fillColor);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeStroke(this.lineStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.lineStroke = SerialUtils.readStroke(stream);
    }
}

