/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.marker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.marker.AbstractMarker;
import org.jfree.chart3d.marker.MarkerChangeEvent;
import org.jfree.chart3d.marker.MarkerChangeListener;
import org.jfree.chart3d.marker.MarkerData;
import org.jfree.chart3d.marker.MarkerLine;
import org.jfree.chart3d.marker.NumberMarker;
import org.jfree.chart3d.marker.ValueMarker;

public class RangeMarker
extends AbstractMarker
implements ValueMarker,
MarkerChangeListener,
Serializable {
    private NumberMarker start;
    private NumberMarker end;
    private String label;
    private Font font;
    private Color labelColor;
    private Anchor2D labelAnchor;
    Color fillColor;

    public RangeMarker(double lowerBound, double upperBound) {
        this(lowerBound, upperBound, null);
    }

    public RangeMarker(double lowerBound, double upperBound, String label) {
        this.start = new NumberMarker(lowerBound);
        this.start.addChangeListener(this);
        this.end = new NumberMarker(upperBound);
        this.end.addChangeListener(this);
        this.label = label;
        this.font = DEFAULT_MARKER_FONT;
        this.labelColor = DEFAULT_LABEL_COLOR;
        this.labelAnchor = Anchor2D.CENTER;
        this.fillColor = DEFAULT_FILL_COLOR;
    }

    public NumberMarker getStart() {
        return this.start;
    }

    public NumberMarker getEnd() {
        return this.end;
    }

    @Override
    public Range getRange() {
        return new Range(this.start.getValue(), this.end.getValue());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.font = font;
        this.fireChangeEvent();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.labelColor = color;
        this.fireChangeEvent();
    }

    public Anchor2D getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(Anchor2D anchor) {
        Args.nullNotPermitted(anchor, "anchor");
        this.labelAnchor = anchor;
        this.fireChangeEvent();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.fillColor = color;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D g2, MarkerData markerData, boolean reverse) {
        Point2D labelPoint;
        MarkerLine startLine = markerData.getStartLine();
        Line2D.Double l1 = new Line2D.Double(startLine.getStartPoint(), startLine.getEndPoint());
        MarkerLine endLine = markerData.getEndLine();
        Line2D.Double l2 = new Line2D.Double(endLine.getStartPoint(), endLine.getEndPoint());
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(((Line2D)l1).getX1(), ((Line2D)l1).getY1());
        ((Path2D)path).lineTo(((Line2D)l1).getX2(), ((Line2D)l1).getY2());
        ((Path2D)path).lineTo(((Line2D)l2).getX2(), ((Line2D)l2).getY2());
        ((Path2D)path).lineTo(((Line2D)l2).getX1(), ((Line2D)l2).getY1());
        path.closePath();
        g2.setPaint(this.fillColor);
        g2.fill(path);
        if (!startLine.isPegged()) {
            g2.setPaint(this.start.getLineColor());
            g2.setStroke(this.start.getLineStroke());
            g2.draw(l1);
        }
        if (!endLine.isPegged()) {
            g2.setPaint(this.end.getLineColor());
            g2.setStroke(this.end.getLineStroke());
            g2.draw(l2);
        }
        if ((labelPoint = markerData.getLabelPoint()) != null) {
            g2.setFont(this.font);
            g2.setColor(this.labelColor);
            this.drawMarkerLabel(g2, this.label, labelPoint.getX(), labelPoint.getY(), markerData.getLabelAnchor(), l1, l2, reverse);
        }
    }

    @Override
    public void markerChanged(MarkerChangeEvent event) {
        this.fireChangeEvent();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + ObjectUtils.hashCode(this.start);
        hash = 97 * hash + ObjectUtils.hashCode(this.end);
        hash = 97 * hash + ObjectUtils.hashCode(this.label);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeMarker other = (RangeMarker)obj;
        if (!ObjectUtils.equals(this.start, other.start)) {
            return false;
        }
        if (!ObjectUtils.equals(this.end, other.end)) {
            return false;
        }
        if (!ObjectUtils.equals(this.label, other.label)) {
            return false;
        }
        if (!ObjectUtils.equals(this.font, other.font)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelColor, other.labelColor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelAnchor, other.labelAnchor)) {
            return false;
        }
        return ObjectUtils.equals(this.fillColor, other.fillColor);
    }
}

