/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.plot;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Chart3D;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.data.Dataset3DChangeEvent;
import org.jfree.chart3d.data.Dataset3DChangeListener;
import org.jfree.chart3d.data.ItemKey;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.plot.Plot3D;
import org.jfree.chart3d.plot.Plot3DChangeEvent;
import org.jfree.chart3d.plot.Plot3DChangeListener;

public abstract class AbstractPlot3D
implements Plot3D,
Dataset3DChangeListener,
Serializable {
    private Chart3D chart = null;
    protected Dimension3D dimensions = new Dimension3D(1.0, 1.0, 1.0);
    protected boolean autoAdjustDimensions = true;
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractPlot3D() {
    }

    @Override
    public Chart3D getChart() {
        return this.chart;
    }

    @Override
    public void setChart(Chart3D chart) {
        this.chart = chart;
    }

    @Override
    public Dimension3D getDimensions() {
        return this.dimensions;
    }

    public boolean isAutoAdjustDimensions() {
        return this.autoAdjustDimensions;
    }

    @Override
    public abstract String generateToolTipText(ItemKey var1);

    @Override
    public abstract void receive(ChartElementVisitor var1);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractPlot3D)) {
            return false;
        }
        AbstractPlot3D that = (AbstractPlot3D)obj;
        return this.dimensions.equals(that.dimensions);
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent(true);
        }
    }

    @Override
    public void addChangeListener(Plot3DChangeListener listener) {
        this.listenerList.add(Plot3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Plot3DChangeListener listener) {
        this.listenerList.remove(Plot3DChangeListener.class, listener);
    }

    public void notifyListeners(Plot3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Plot3DChangeListener.class) continue;
            ((Plot3DChangeListener)listeners[i + 1]).plotChanged(event);
        }
    }

    protected void fireChangeEvent(boolean requiresWorldUpdate) {
        this.notifyListeners(new Plot3DChangeEvent(this, this, requiresWorldUpdate));
    }

    @Override
    public void datasetChanged(Dataset3DChangeEvent event) {
        this.notifyListeners(new Plot3DChangeEvent(event, this, true));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

