/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.plot;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart3d.Colors;
import org.jfree.chart3d.data.DefaultKeyedValues;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.plot.ColorSource;

public final class StandardColorSource<K extends Comparable<K>>
implements ColorSource<K>,
Serializable {
    private Color[] standardColors;
    private DefaultKeyedValues<K, Color> colors;

    public StandardColorSource() {
        this(Colors.getDefaultColors());
    }

    public StandardColorSource(Color ... colors) {
        Args.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.standardColors = (Color[])colors.clone();
        this.colors = new DefaultKeyedValues();
    }

    @Override
    public Color getColor(K key) {
        Color c = this.colors.getValue(key);
        if (c != null) {
            return c;
        }
        c = this.standardColors[this.colors.getItemCount() % this.standardColors.length];
        this.colors.put(key, c);
        return c;
    }

    @Override
    public void setColor(K key, Color color) {
        if (color != null) {
            this.colors.put(key, color);
        } else {
            this.colors.remove(key);
        }
    }

    @Override
    public void style(Color ... colors) {
        this.standardColors = colors;
        this.colors.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardColorSource)) {
            return false;
        }
        StandardColorSource that = (StandardColorSource)obj;
        if (!Arrays.equals(this.standardColors, that.standardColors)) {
            return false;
        }
        return this.colors.equals(that.colors);
    }
}

